/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.ui.size.vo.LibraryMemoryComponent;
import java.util.LinkedHashSet;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class IDFSizeDataLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final String[] columns;

    public IDFSizeDataLabelProvider(LinkedHashSet<String> columns) {
        this.columns = columns.toArray(new String[0]);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LibraryMemoryComponent data = (LibraryMemoryComponent)element;
        if (columnIndex >= this.columns.length) {
            return null;
        }
        String columnName = this.columns[columnIndex];
        if (columnName.equals("File Name")) {
            return data.getName();
        }
        if (columnName.equals("Total")) {
            return String.valueOf(data.getSize());
        }
        if (columnName.contains("->")) {
            String[] split = columnName.split(" -> ");
            if (split.length == 2) {
                String memoryType = split[0];
                String memorySection = split[1];
                try {
                    return String.valueOf(data.getMemoryTypes().get(memoryType).getSections().get(memorySection).getSize());
                }
                catch (Exception e) {
                    return "0";
                }
            }
        } else if (columnName.endsWith(" Total")) {
            String memoryType = columnName.replace(" Total", "");
            try {
                return String.valueOf(data.getMemoryTypes().get(memoryType).getSize());
            }
            catch (Exception e) {
                return "0";
            }
        }
        return "";
    }
}

