/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.ConsoleManager;
import com.espressif.idf.core.util.IdfCommandExecutor;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.wizard.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IdfReconfigureHandler
extends AbstractHandler {
    private static final String DEFAULT_TARGET = "esp32";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IProject selectedProject = EclipseUtil.getSelectedProjectInExplorer();
        Job job = new Job(Messages.IdfReconfigureJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IdfCommandExecutor executor = new IdfCommandExecutor(IdfReconfigureHandler.this.getCurrentTarget(), ConsoleManager.getConsole((String)"CDT Build Console"));
                IStatus status = executor.executeReconfigure(selectedProject);
                try {
                    IDEWorkbenchPlugin.getPluginWorkspace().getRoot().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
                return status;
            }
        };
        job.schedule();
        return null;
    }

    private String getCurrentTarget() {
        ILaunchBarManager launchBarManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
        try {
            ILaunchTarget target = launchBarManager.getActiveLaunchTarget();
            return target.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "");
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return DEFAULT_TARGET;
        }
    }
}

