/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.dialogs.Messages;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectLaunchConfigDialog
extends TitleAreaDialog {
    private Combo descriptorsCombo;
    private final List<String> suitableConfiguratios;

    public SelectLaunchConfigDialog(Shell parentShell, List<String> suitableConfiguratios) {
        super(parentShell);
        this.suitableConfiguratios = suitableConfiguratios;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectLaunchConfigDialog_Title);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SelectLaunchConfigDialog_Title);
        this.setMessage(Messages.SelectLaunchConfigDialog_Text, 1);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Launch", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label descriptorsLabel = new Label(container, 0);
        descriptorsLabel.setText(Messages.SelectLaunchConfigDialog_LableText);
        GridData comboLayoutData = new GridData();
        comboLayoutData.grabExcessHorizontalSpace = true;
        comboLayoutData.horizontalAlignment = 4;
        comboLayoutData.horizontalSpan = 1;
        this.descriptorsCombo = new Combo(container, 8);
        this.descriptorsCombo.setItems(this.suitableConfiguratios.toArray(new String[0]));
        this.descriptorsCombo.select(0);
        this.descriptorsCombo.setLayoutData((Object)comboLayoutData);
        return super.createDialogArea(parent);
    }

    protected void okPressed() {
        ILaunchBarManager launchBarManager = UIPlugin.getService(ILaunchBarManager.class);
        try {
            ILaunchDescriptor[] descriptors = launchBarManager.getLaunchDescriptors();
            Optional<ILaunchDescriptor> optDisc = Stream.of(descriptors).filter(disc -> disc.getName().contentEquals(this.descriptorsCombo.getText())).findFirst();
            if (optDisc.isPresent()) {
                launchBarManager.setActiveLaunchDescriptor(optDisc.get());
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        super.okPressed();
    }
}

