/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.model;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnDateFilter;
import org.eclipse.nebula.widgets.xviewer.core.model.DateRangeType;
import org.eclipse.nebula.widgets.xviewer.core.util.Strings;
import org.eclipse.nebula.widgets.xviewer.core.util.XmlUtil;

public class ColumnFilterData {
    private static final String COLUMN_FILTER_TAG = "xColFilter";
    private static final String COLUMN_ID_TAG = "id";
    private static final String FILTER_TEXT_TAG = "str";
    private static final String DATE_FILTER_TYPE_TAG = "dateType";
    private static final String DATE1_FILTER_TAG = "date1";
    private static final String DATE2_FILTER_TAG = "date2";
    private final Map<String, String> colIdToFilterText = new HashMap<String, String>();
    private final Map<String, ColumnDateFilter> colIdToDateFilter = new HashMap<String, ColumnDateFilter>();
    private static Pattern p = Pattern.compile("<xColFilter>(.*?)</xColFilter>");

    public String getFilterText(String colId) {
        return this.colIdToFilterText.get(colId);
    }

    public Set<String> getColIds() {
        HashSet<String> colIds = new HashSet<String>(this.colIdToFilterText.keySet());
        colIds.addAll(this.colIdToDateFilter.keySet());
        return colIds;
    }

    public void setFilterText(String colId, String filterText) {
        this.colIdToFilterText.put(colId, filterText);
    }

    public void clear() {
        this.colIdToFilterText.clear();
        this.colIdToDateFilter.clear();
    }

    public void removeFilterText(String colId) {
        this.colIdToFilterText.remove(colId);
    }

    public String getXml() {
        StringBuilder sb = new StringBuilder();
        for (String colId : this.getColIds()) {
            ColumnDateFilter dateFilter;
            StringBuilder innerSb = new StringBuilder();
            innerSb.append(XmlUtil.addTagData(COLUMN_ID_TAG, colId));
            String filterText = this.colIdToFilterText.get(colId);
            if (Strings.isValid(filterText)) {
                innerSb.append(XmlUtil.addTagData(FILTER_TEXT_TAG, filterText));
            }
            if ((dateFilter = this.colIdToDateFilter.get(colId)) != null) {
                Date date2;
                innerSb.append(XmlUtil.addTagData(DATE_FILTER_TYPE_TAG, dateFilter.getType().name()));
                Date date1 = dateFilter.getDate1();
                if (date1 != null) {
                    innerSb.append(XmlUtil.addTagData(DATE1_FILTER_TAG, String.valueOf(date1.getTime())));
                }
                if ((date2 = dateFilter.getDate2()) != null) {
                    innerSb.append(XmlUtil.addTagData(DATE2_FILTER_TAG, String.valueOf(date2.getTime())));
                }
            }
            sb.append(XmlUtil.addTagData(COLUMN_FILTER_TAG, innerSb.toString()));
        }
        return sb.toString();
    }

    public void setFromXml(String xml) {
        this.colIdToFilterText.clear();
        Matcher columnMatch = p.matcher(xml);
        while (columnMatch.find()) {
            String dateFilterTypeStr;
            String columnXml = columnMatch.group(1);
            String columnId = XmlUtil.getTagData(columnXml, COLUMN_ID_TAG);
            String filterText = XmlUtil.getTagData(columnXml, FILTER_TEXT_TAG);
            if (Strings.isValid(filterText)) {
                this.colIdToFilterText.put(columnId, filterText);
            }
            if (!Strings.isValid(dateFilterTypeStr = XmlUtil.getTagData(columnXml, DATE_FILTER_TYPE_TAG))) continue;
            DateRangeType dateRangeType = DateRangeType.get(dateFilterTypeStr);
            Date date1 = null;
            Date date2 = null;
            if (dateRangeType != DateRangeType.None) {
                String date2Str;
                String date1Str = XmlUtil.getTagData(columnXml, DATE1_FILTER_TAG);
                if (Strings.isValid(date1Str)) {
                    date1 = new Date(Long.valueOf(date1Str));
                }
                if (Strings.isValid(date2Str = XmlUtil.getTagData(columnXml, DATE2_FILTER_TAG))) {
                    date2 = new Date(Long.valueOf(date2Str));
                }
            }
            if (date1 == null && date2 == null) continue;
            this.colIdToDateFilter.put(columnId, new ColumnDateFilter(dateRangeType, date1, date2));
        }
    }

    public boolean isFiltered() {
        return this.colIdToFilterText.size() > 0;
    }

    public void setDateFilter(String columnId, DateRangeType dateRangeType, Date date1, Date date2) {
        this.colIdToDateFilter.put(columnId, new ColumnDateFilter(dateRangeType, date1, date2));
    }

    public ColumnDateFilter getDateFilter(String columnId) {
        return this.colIdToDateFilter.get(columnId);
    }

    public void removeDateFilter(String columnId) {
        this.colIdToDateFilter.remove(columnId);
    }

    public String toString() {
        return "ColumnFilterData [colIdToFilterText=" + String.valueOf(this.colIdToFilterText) + ", colIdToDateFilter=" + String.valueOf(this.colIdToDateFilter) + "]";
    }
}

