/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.wizards;

import com.cthing.cmakeed.ui.editor.CMakeEditorUI;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class CMakeFileNewWizardPage
extends WizardPage {
    private Text projectText;
    private Text nameText;
    private Text versionText;
    private Text summaryText;
    private Combo groupCombo;
    private Text licenseText;
    private Text URLText;
    private Text source0Text;
    private GridData gd;
    private Combo templateCombo;
    private ISelection selection;
    private String selectedTemplate = "minimal";
    private String content;

    public CMakeFileNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("New specfile based on a template");
        this.setDescription("This wizard creates a new specfile based on a selected template.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Project:");
        this.projectText = new Text(container, 2052);
        this.gd = new GridData(768);
        this.projectText.setLayoutData((Object)this.gd);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMakeFileNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Select a project...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeFileNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("Select a Template:");
        this.templateCombo = new Combo(container, 0);
        try {
            this.populateTemplateCombo(this.templateCombo);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        label = new Label(container, 0);
        this.templateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMakeFileNewWizardPage.this.selectedTemplate = ((Combo)e.getSource()).getText();
                InputStream inputStream = null;
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    CMakeFileNewWizardPage.this.content = "";
                    this.setDefaultValues();
                    while ((line = reader.readLine()) != null) {
                        String[] items;
                        String value;
                        if (line.startsWith("Name:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.nameText, line);
                        }
                        if (line.startsWith("Version:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.versionText, line);
                        }
                        if (line.startsWith("Summary:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.summaryText, line);
                        }
                        if (line.startsWith("Group:") && !(value = (items = line.split(":", 2))[1].trim()).equals("")) {
                            CMakeFileNewWizardPage.this.groupCombo.setText(value);
                        }
                        if (line.startsWith("License:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.licenseText, line);
                        }
                        if (line.startsWith("URL:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.URLText, line);
                        }
                        if (line.startsWith("Source0:")) {
                            CMakeFileNewWizardPage.this.setTemplateTagValue(CMakeFileNewWizardPage.this.source0Text, line);
                        }
                        CMakeFileNewWizardPage.this.content = String.valueOf(CMakeFileNewWizardPage.this.content) + line + "\n";
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private void setDefaultValues() {
            }
        });
        this.nameText = this.setTextItem(container, "&Name:");
        this.versionText = this.setTextItem(container, "&Version:");
        this.summaryText = this.setTextItem(container, "&Summary:");
        label = new Label(container, 0);
        label.setText("&Group:");
        label = new Label(container, 0);
        this.licenseText = this.setTextItem(container, "&License:");
        this.URLText = this.setTextItem(container, "&URL:");
        this.source0Text = this.setTextItem(container, "Source&0:");
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private Text setTextItem(Composite container, String textLabel) {
        Label label = new Label(container, 0);
        label.setText(textLabel);
        Text text = new Text(container, 2052);
        text.setLayoutData((Object)this.gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMakeFileNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        return text;
    }

    private void setTemplateTagValue(Text text, String line) {
        String[] items = line.split(":", 2);
        String value = items[1].trim();
        if (!value.equals("")) {
            text.setText(value);
        }
    }

    public String getProjectName() {
        return this.projectText.getText();
    }

    public String getFileName() {
        return this.nameText.getText() + ".spec";
    }

    public String getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public String getContent() {
        InputStream inputStream = null;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
        try {
            Object line;
            this.content = "";
            while ((line = reader.readLine()) != null) {
                if (((String)line).startsWith("Name:")) {
                    line = "Name:           " + this.nameText.getText();
                }
                if (((String)line).startsWith("Version:")) {
                    line = "Version:        " + this.versionText.getText();
                }
                if (((String)line).startsWith("Summary:")) {
                    line = "Summary:        " + this.summaryText.getText();
                }
                if (((String)line).startsWith("Group:")) {
                    line = "Group:          " + this.groupCombo.getText();
                }
                if (((String)line).startsWith("License:")) {
                    line = "License:        " + this.licenseText.getText();
                }
                if (((String)line).startsWith("URL:")) {
                    line = "URL:            " + this.URLText.getText();
                }
                if (((String)line).startsWith("Source0:")) {
                    line = "Source0:        " + this.source0Text.getText();
                }
                this.content = String.valueOf(this.content) + (String)line + "\n";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.content;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.projectText.setText(container.getFullPath().toString());
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.projectText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getProjectName()));
        String fileName = this.getFileName();
        if (this.getProjectName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("The Project must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("Spec file name must be specified");
            return;
        }
        String packageName = this.nameText.getText();
        if (packageName.indexOf(" ") != -1 || packageName.indexOf("<") != -1 || packageName.indexOf(">") != -1 || packageName.indexOf("=") != -1) {
            this.updateStatus("The Name tag must not include whitespace and should not include any numeric operators ('<', '>','=')");
            return;
        }
        if (this.versionText.getText().indexOf("-") > -1) {
            this.updateStatus("Please, no dashes in the version!");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void populateTemplateCombo(Combo templateCombo) throws CoreException {
        Template[] templates;
        Template[] templateArray = templates = CMakeEditorUI.getDefault().getTemplateStore().getTemplates();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            templateCombo.add(template.getName());
            ++n2;
        }
    }
}

