/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.rules;

import com.cthing.cmakeed.core.uservariables.CMakeUserVariable;
import com.cthing.cmakeed.core.uservariables.CMakeUserVariables;
import com.cthing.cmakeed.ui.editor.CMakeNameDetector;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CMakeUserVariableRule
implements IRule,
IPredicateRule {
    private IToken userVariableToken;
    private IWordDetector detector = new CMakeNameDetector();
    private StringBuilder buffer = new StringBuilder();
    public static Map<IDocument, CMakeUserVariables> userVariableMap;

    public CMakeUserVariableRule(IToken commandToken) {
        this.userVariableToken = commandToken;
        if (userVariableMap == null) {
            userVariableMap = new LinkedHashMap<IDocument, CMakeUserVariables>();
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (scanner instanceof CMakePartitionScanner) {
            int offset;
            CMakePartitionScanner cscan = (CMakePartitionScanner)scanner;
            IDocument doc = cscan.getDocument();
            CMakeUserVariables userVariables = userVariableMap.get(doc);
            if (userVariables == null) {
                userVariables = new CMakeUserVariables();
                userVariableMap.put(doc, userVariables);
            }
            if (EditorUtils.inArguments(doc, offset = cscan.getTokenOffset()) && EditorUtils.startOfWord(doc, offset)) {
                this.buffer.setLength(0);
                int ch = scanner.read();
                while (ch != -1 && this.detector.isWordPart((char)ch)) {
                    this.buffer.append((char)ch);
                    ch = scanner.read();
                }
                scanner.unread();
                CMakeUserVariable var = userVariables.getUserVariable(this.buffer.toString());
                if (var != null) {
                    return this.userVariableToken;
                }
                String uvar = this.buffer.toString();
                if (!((uvar = uvar.trim()).length() <= 0 || uvar.contains(".") || uvar.contains("/") || uvar.startsWith("/") || uvar.startsWith("-") || !EditorUtils.firstArgument(doc, offset))) {
                    userVariables.addUserVariable(uvar);
                    return this.userVariableToken;
                }
                EditorUtils.unread(scanner, this.buffer);
            }
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.userVariableToken;
    }
}

