/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.serial.monitor.core;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.GenericJsonReader;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.serial.monitor.core.LocalTerminal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;

public class IDFMonitor {
    private String port;
    private String pythonBinPath;
    private IProject project;
    private String filterOptions;
    private int serverPort;
    private boolean encryptionOption;

    public IDFMonitor(IProject project, String port, String filterOptions, boolean encryptionOption, String pythonBinPath, int serverPort) {
        this.project = project;
        this.port = port;
        this.pythonBinPath = pythonBinPath;
        this.filterOptions = filterOptions;
        this.encryptionOption = encryptionOption;
        this.serverPort = serverPort;
    }

    private List<String> commandArgsWithSocketServer() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.pythonBinPath);
        args.add(IDFUtil.getIDFMonitorPythonScriptFile().getAbsolutePath());
        args.add("--make");
        args.add(String.valueOf(Path.fromOSString((String)IDFUtil.getIDFPythonEnvPath())) + " " + String.valueOf(Path.fromOSString((String)IDFUtil.getIDFPythonScriptFile().getAbsolutePath())));
        if (!StringUtil.isEmpty((String)this.filterOptions)) {
            args.add("--print_filter");
            args.add(this.filterOptions);
        }
        if (this.isDebuggerRunning(this.project) && this.isNoResetFlagSupported()) {
            args.add("--no-reset");
        }
        args.add("-p");
        args.add(this.port);
        args.add("-b");
        args.add(this.getMonitorBaudRate());
        if (this.encryptionOption) {
            args.add("--encrypted");
        }
        args.add("--ws");
        args.add("ws://localhost:".concat(String.valueOf(this.serverPort)));
        args.add(this.getElfFilePath(this.project).toString());
        return args;
    }

    private IPath getElfFilePath(IProject project) {
        try {
            String buildDir = IDFUtil.getBuildDir((IProject)project);
            GenericJsonReader jsonReader = new GenericJsonReader(buildDir + File.separator + "project_description.json");
            String value = jsonReader.getValue("app_elf");
            if (!StringUtil.isEmpty((String)value)) {
                return new Path(buildDir).append(value);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDebuggerRunning(IProject project) {
        ILaunchManager launchManager = this.getLaunchManager();
        boolean isDebugLaunchRunning = false;
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                IResource[] resources = config.getMappedResources();
                if (resources != null && resources[0].getProject().equals((Object)project) && (isDebugLaunchRunning = DebugUtils.isLaunchConfigurationStarted((ILaunchConfiguration)config))) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return false;
    }

    private boolean isNoResetFlagSupported() {
        String version = IDFUtil.getEspIdfVersion();
        Pattern p = Pattern.compile("([0-9][.][0-9])");
        Matcher m = p.matcher(version);
        return m.find() && Double.parseDouble(m.group(0)) >= 5.0;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private String getMonitorBaudRate() {
        return new SDKConfigJsonReader(this.project).getValue("ESPTOOLPY_MONITOR_BAUD");
    }

    public Process start() throws Exception {
        List<String> arguments = this.commandArgsWithSocketServer();
        Logger.log((String)arguments.toString());
        Map idfEnvMap = new IDFEnvironmentVariables().getSystemEnvMap();
        idfEnvMap.put("PYTHONUNBUFFERED", "1");
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(idfEnvMap);
        Logger.log((String)((Object)environment).toString());
        String idfPath = (String)environment.get("PATH");
        String processPath = (String)environment.get("Path");
        if (!StringUtil.isEmpty((String)idfPath) && !StringUtil.isEmpty((String)processPath)) {
            idfPath = idfPath.concat(";").concat(processPath);
            environment.put("PATH", idfPath);
            environment.remove("Path");
        }
        environment.remove("TERM_PROGRAM");
        environment.put("TERM", "vt102");
        Logger.log((String)((Object)environment).toString());
        IPath workingDir = this.project.getLocation();
        LocalTerminal localTerminal = new LocalTerminal(arguments, workingDir.toFile(), environment);
        return localTerminal.connect();
    }
}

