/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.launch.strategies;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.launch.strategies.EimLauncherStrategy;
import java.io.IOException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class AbstractLoggingLauncherStrategy
implements EimLauncherStrategy {
    protected final Display display;
    protected final MessageConsoleStream standardConsoleStream;
    protected final MessageConsoleStream errorConsoleStream;

    protected AbstractLoggingLauncherStrategy(Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        this.display = display;
        this.standardConsoleStream = standardConsoleStream;
        this.errorConsoleStream = errorConsoleStream;
    }

    protected void logMessage(String message) {
        this.display.asyncExec(() -> {
            try {
                this.standardConsoleStream.write(message);
            }
            catch (IOException e) {
                Logger.log(e);
                this.logError(e.getMessage());
            }
        });
        Logger.log(message);
    }

    protected void logError(String message) {
        this.display.asyncExec(() -> {
            try {
                this.errorConsoleStream.write(message);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        });
        Logger.log(message);
    }
}

