/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.exceptions;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.Messages;

public class EimVersionMismatchException
extends Exception {
    private static final long serialVersionUID = 4471390598613711666L;
    private final String expectedVersion;
    private final String foundVersion;

    public EimVersionMismatchException(String expectedVersion, String foundVersion) {
        super(String.format(Messages.EimVersionMismatchExceptionMessage, expectedVersion, foundVersion));
        Logger.log(String.format("Invalid eim_idf.json version. Expected: %s, but found: %s.", expectedVersion, foundVersion));
        this.expectedVersion = expectedVersion;
        this.foundVersion = foundVersion;
    }

    public String getExpectedVersion() {
        return this.expectedVersion;
    }

    public String getFoundVersion() {
        return this.foundVersion;
    }

    public String msgTitle() {
        return Messages.EimVersionMismatchExceptionMessageTitle;
    }
}

