/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.tools.Messages;
import com.espressif.idf.core.tools.util.ToolsUtility;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.core.tools.vo.IdfInstalled;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.LspService;
import com.espressif.idf.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.console.MessageConsoleStream;

public class SetupToolsInIde
extends Job {
    private EimJson eimJson;
    private IdfInstalled idfInstalled;
    private MessageConsoleStream errorConsoleStream;
    private MessageConsoleStream standardConsoleStream;
    private Map<String, String> envVarsFromActivationScriptMap;
    private Map<String, String> existingEnvVarsInIdeForRollback;

    public SetupToolsInIde(IdfInstalled idfInstalled, EimJson eimJson, MessageConsoleStream errorConsoleStream, MessageConsoleStream standardConsoleStream) {
        super("Tools Setup");
        this.idfInstalled = idfInstalled;
        this.eimJson = eimJson;
        this.errorConsoleStream = errorConsoleStream;
        this.standardConsoleStream = standardConsoleStream;
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.setupTools(monitor);
    }

    public void rollback() {
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        for (Map.Entry<String, String> entry : this.existingEnvVarsInIdeForRollback.entrySet()) {
            idfEnvironmentVariables.addEnvVariable(entry.getKey(), entry.getValue());
        }
        IDFUtil.updateEspressifPrefPageOpenocdPath();
        try {
            this.setUpToolChainsAndTargets(true);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private IStatus setupTools(IProgressMonitor monitor) {
        monitor.beginTask("Setting up tools in IDE", 7);
        monitor.worked(1);
        ArrayList<String> arguemnts = new ArrayList();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.addGitToEnvironment(env, this.eimJson.getGitPath());
        arguemnts = ToolsUtility.getExportScriptCommand(this.idfInstalled.getActivationScript());
        ProcessBuilderFactory processBuilderFactory = new ProcessBuilderFactory();
        try {
            monitor.setTaskName("Running Activation Script");
            IStatus status = processBuilderFactory.runInBackground(arguemnts, (IPath)Path.ROOT, System.getenv());
            if (status == null) {
                Logger.log(IDFCorePlugin.getPlugin(), IDFCorePlugin.errorStatus("Status returned null from activation script process", null));
                return IDFCorePlugin.errorStatus("Status returned null from activation script process", null);
            }
            if (status.getSeverity() == 4) {
                this.log(status.getException() != null ? status.getException().getMessage() : status.getMessage(), 4);
                return status;
            }
            String activationScriptOutput = status.getMessage();
            if (StringUtil.isEmpty(activationScriptOutput)) {
                this.log("Activation Script Output must not be empty", 4);
                return IDFCorePlugin.errorStatus("Activation Script Output must not be empty", null);
            }
            monitor.worked(1);
            this.log(activationScriptOutput, 0);
            monitor.setTaskName("Processing output from activation script");
            this.log("Processing output from activation script", 1);
            this.envVarsFromActivationScriptMap = this.parseEnvKeys(activationScriptOutput);
            monitor.worked(1);
            monitor.setTaskName("Setting up IDE environment");
            this.log("Setting up IDE environment variables", 1);
            this.setupEnvVarsInEclipse();
            monitor.worked(1);
            monitor.setTaskName("Setting up toolchains");
            this.log("Setting up toolchains", 1);
            this.setUpToolChainsAndTargets(false);
            monitor.worked(1);
            monitor.setTaskName("Copying OpenOCD Rules");
            this.log("Copying OpenOCD Rules", 1);
            this.copyOpenOcdRules();
            monitor.worked(1);
            monitor.setTaskName("Applying Clangd Preferences");
            this.log("Applying Clangd Preferences", 1);
            LspService lspService = new LspService();
            lspService.updateClangdPath();
            lspService.updateQueryDriver();
            this.log("Tools Setup complete", 1);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            Logger.log(e);
            return IDFCorePlugin.errorStatus(e.getMessage(), e);
        }
    }

    private void copyOpenOcdRules() {
        if (Platform.getOS().equals("linux") && !IDFUtil.getOpenOCDLocation().equalsIgnoreCase("")) {
            this.log(Messages.InstallToolsHandler_CopyingOpenOCDRules, 0);
            StringBuilder pathToRules = new StringBuilder();
            pathToRules.append(IDFUtil.getOpenOCDLocation());
            pathToRules.append("/../share/openocd/contrib/60-openocd.rules");
            File rulesFile = new File(pathToRules.toString());
            if (rulesFile.exists()) {
                final java.nio.file.Path source = Paths.get(pathToRules.toString(), new String[0]);
                final java.nio.file.Path target = Paths.get("/etc/udev/rules.d/60-openocd.rules", new String[0]);
                this.log(String.format(Messages.InstallToolsHandler_OpenOCDRulesCopyPaths, source.toString(), target.toString()), 0);
                Display.getDefault().syncExec(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            if (target.toFile().exists()) {
                                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 200);
                                messageBox.setText(Messages.InstallToolsHandler_OpenOCDRulesCopyWarning);
                                messageBox.setMessage(Messages.InstallToolsHandler_OpenOCDRulesCopyWarningMessage);
                                int response = messageBox.open();
                                if (response != 64) {
                                    SetupToolsInIde.this.log(Messages.InstallToolsHandler_OpenOCDRulesNotCopied, 4);
                                    return;
                                }
                                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            } else {
                                Files.copy(source, target, new CopyOption[0]);
                            }
                            SetupToolsInIde.this.log(Messages.InstallToolsHandler_OpenOCDRulesCopied, 0);
                            return;
                        }
                        catch (IOException e) {
                            Logger.log(e);
                            SetupToolsInIde.this.log(Messages.InstallToolsHandler_OpenOCDRulesCopyError, 4);
                        }
                    }
                });
            }
        }
    }

    private String getUpdatedPathWithSystemPath() {
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        String systemPath = idfEnvironmentVariables.getEnvValue("SYSTEM_PATH");
        String path = idfEnvironmentVariables.getEnvValue("PATH") + File.pathSeparator + systemPath;
        idfEnvironmentVariables.removeEnvVariable("SYSTEM_PATH");
        return path;
    }

    private IStatus loadTargetsAvailableFromIdfInCurrentToolSet(boolean rollback) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(rollback ? this.existingEnvVarsInIdeForRollback.get("PYTHON_EXE_PATH") : this.idfInstalled.getPython());
        arguments.add(IDFUtil.getIDFPythonScriptFile(rollback ? this.existingEnvVarsInIdeForRollback.get("IDF_PATH") : this.envVarsFromActivationScriptMap.get("IDF_PATH")).getAbsolutePath());
        arguments.add("--list-targets");
        this.log("Executing:" + ((Object)arguments).toString(), 0);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.prepEnvMap(env);
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        StringBuilder output = new StringBuilder();
        int waitCount = 10;
        try {
            String line;
            Process process = processRunner.run(arguments, (IPath)Path.ROOT, env);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
            while (process.isAlive() && waitCount > 0) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    Logger.log(e);
                }
                --waitCount;
            }
            if (waitCount == 0) {
                this.log("Process possibly stuck", 4);
                return Status.CANCEL_STATUS;
            }
            Status status = new Status(process.exitValue() == 0 ? 0 : 4, "com.espressif.idf.core", process.exitValue(), output.toString(), null);
            if (status.getSeverity() == 4) {
                this.log(status.getException() != null ? status.getException().getMessage() : status.getMessage(), 4);
            }
            this.log(status.getMessage(), 0);
            return status;
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
            return IDFCorePlugin.errorStatus(e.getMessage(), e);
        }
    }

    private void prepEnvMap(Map<String, String> env) {
        env.put("PYTHONUNBUFFERED", "1");
        this.loadIdfPathWithSystemPath(env);
        this.addGitToEnvironment(env, this.eimJson.getGitPath());
    }

    private void loadIdfPathWithSystemPath(Map<String, String> systemEnv) {
        String idfExportPath = this.envVarsFromActivationScriptMap.get("PATH");
        String pathVar = "PATH";
        String pathEntry = systemEnv.get(pathVar);
        if (pathEntry == null && (pathEntry = systemEnv.get(pathVar = "Path")) == null) {
            Logger.log(new Exception("No PATH found in the system environment variables"));
        }
        if (!StringUtil.isEmpty(pathEntry)) {
            idfExportPath = idfExportPath.replace("$PATH", pathEntry);
            idfExportPath = idfExportPath.replace("%PATH%", pathEntry);
        }
        systemEnv.put(pathVar, idfExportPath);
        for (Map.Entry<String, String> entry : this.envVarsFromActivationScriptMap.entrySet()) {
            if (entry.getKey().equals("PATH")) continue;
            systemEnv.put(entry.getKey(), entry.getValue());
        }
    }

    private void setUpToolChainsAndTargets(boolean rollback) {
        IStatus status = this.loadTargetsAvailableFromIdfInCurrentToolSet(rollback);
        if (status.getSeverity() == 4) {
            Logger.log("Unable to get IDF targets from current toolset");
            return;
        }
        List<String> targets = this.extractTargets(status.getMessage());
        ESPToolChainManager espToolChainManager = new ESPToolChainManager();
        espToolChainManager.removeLaunchTargetsNotPresent(targets);
        espToolChainManager.removeCmakeToolChains();
        espToolChainManager.removeStdToolChains();
        espToolChainManager.configureToolChain(targets);
    }

    private List<String> extractTargets(String input) {
        ArrayList<String> targets = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^esp32.*", 8);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            targets.add(matcher.group());
        }
        return targets;
    }

    private void setupEnvVarsInEclipse() {
        this.createExistingBackup();
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        for (Map.Entry<String, String> entry : this.envVarsFromActivationScriptMap.entrySet()) {
            idfEnvironmentVariables.addEnvVariable(entry.getKey(), entry.getValue());
        }
        String path = this.getUpdatedPathWithSystemPath();
        idfEnvironmentVariables.addEnvVariable("PATH", path);
        idfEnvironmentVariables.addEnvVariable("IDF_COMPONENT_MANAGER", "1");
        idfEnvironmentVariables.addEnvVariable("IDF_MAINTAINER", "1");
        idfEnvironmentVariables.addEnvVariable("ESP_IDF_EIM_ID", this.idfInstalled.getId());
        idfEnvironmentVariables.addEnvVariable("PYTHON_EXE_PATH", this.idfInstalled.getPython());
        IDFUtil.updateEspressifPrefPageOpenocdPath();
    }

    private void createExistingBackup() {
        if (this.existingEnvVarsInIdeForRollback == null) {
            this.existingEnvVarsInIdeForRollback = new HashMap<String, String>();
        }
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        this.existingEnvVarsInIdeForRollback.putAll(idfEnvironmentVariables.getEnvMap());
    }

    private Map<String, String> parseEnvKeys(String activationScriptOutput) {
        return Arrays.stream(activationScriptOutput.split(System.lineSeparator())).map(String::trim).filter(line -> line.contains("=")).map(line -> line.split("=", 2)).filter(parts -> ((String[])parts).length == 2 && !parts[0].isEmpty() && !parts[1].isEmpty()).collect(Collectors.toMap(parts -> parts[0].trim(), parts -> parts[1].trim()));
    }

    private void log(String message, int severity) {
        Logger.log(message);
        if (severity == 4) {
            this.printToErrorConsole(message);
        } else {
            this.printToStandardConsole(message);
        }
    }

    private void log(String message, Exception e) {
        Logger.log(message);
        Logger.log(e);
        this.printToErrorConsole(message);
    }

    private void printToErrorConsole(String message) {
        if (this.errorConsoleStream != null) {
            this.errorConsoleStream.println(message);
        }
    }

    private void printToStandardConsole(String message) {
        if (this.standardConsoleStream != null) {
            this.standardConsoleStream.println(message);
        }
    }

    private void addGitToEnvironment(Map<String, String> envMap, String executablePath) {
        Path gitPath = new Path(executablePath);
        if (gitPath.toFile().exists()) {
            String gitDir = gitPath.removeLastSegments(1).toOSString();
            String path1 = envMap.get("PATH");
            String path2 = envMap.get("Path");
            if (!StringUtil.isEmpty(path1) && !path1.contains(gitDir)) {
                path1 = gitDir.concat(";").concat(path1);
                envMap.put("PATH", path1);
            } else if (!StringUtil.isEmpty(path2) && !path2.contains(gitDir)) {
                path2 = gitDir.concat(";").concat(path2);
                envMap.put("Path", path2);
            }
        }
    }
}

