/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.toolchain;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.IDFTargets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IDFTargetsReader {
    private static final String CONSTANTS_FILE_PATH = "tools/idf_py_actions/constants.py";
    private static final Pattern SUPPORTED_TARGETS_PATTERN = Pattern.compile("SUPPORTED_TARGETS\\s*=\\s*\\[([^\\]]*)\\]", 8);
    private static final Pattern PREVIEW_TARGETS_PATTERN = Pattern.compile("PREVIEW_TARGETS\\s*=\\s*\\[([^\\]]*)\\]", 8);

    public static IDFTargets readTargetsFromEspIdf(String idfPath) {
        IDFTargets targets = new IDFTargets();
        if (idfPath == null || idfPath.trim().isEmpty()) {
            Logger.log("ESP-IDF path is null or empty, cannot read targets");
            return targets;
        }
        Path constantsFilePath = Paths.get(idfPath, CONSTANTS_FILE_PATH);
        if (!Files.exists(constantsFilePath, new LinkOption[0])) {
            Logger.log("Constants file not found at: " + String.valueOf(constantsFilePath));
            return targets;
        }
        try {
            String content = new String(Files.readAllBytes(constantsFilePath));
            List<String> supportedTargets = IDFTargetsReader.extractTargets(content, SUPPORTED_TARGETS_PATTERN);
            for (String target : supportedTargets) {
                targets.addSupportedTarget(target.trim());
            }
            List<String> previewTargets = IDFTargetsReader.extractTargets(content, PREVIEW_TARGETS_PATTERN);
            for (String target : previewTargets) {
                targets.addPreviewTarget(target.trim());
            }
            Logger.log("Successfully read " + supportedTargets.size() + " supported targets and " + previewTargets.size() + " preview targets");
        }
        catch (IOException e) {
            Logger.log("Error reading constants file: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.log("Unexpected error reading targets: " + e.getMessage());
        }
        return targets;
    }

    private static List<String> extractTargets(String content, Pattern pattern) {
        ArrayList<String> targets = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            String[] targetArray;
            String targetsString = matcher.group(1);
            String[] stringArray = targetArray = targetsString.split(",");
            int n = targetArray.length;
            int n2 = 0;
            while (n2 < n) {
                String target = stringArray[n2];
                String cleanTarget = target.replaceAll("['\"\\s]", "").trim();
                if (!cleanTarget.isEmpty()) {
                    targets.add(cleanTarget);
                }
                ++n2;
            }
        }
        return targets;
    }
}

