/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.build;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.internal.Messages;

public class ActiveLaunchConfigurationProvider {
    private ILaunchBarManager launchBarManager;

    public ActiveLaunchConfigurationProvider(ILaunchBarManager launchBarManager) {
        this.launchBarManager = launchBarManager;
    }

    public ActiveLaunchConfigurationProvider() {
        this(IDFCorePlugin.getService(ILaunchBarManager.class));
    }

    public ILaunchConfiguration getActiveLaunchConfiguration() throws CoreException {
        ILaunchConfiguration configuration = this.launchBarManager.getActiveLaunchConfiguration();
        if (configuration == null) {
            Job[] jobs = Job.getJobManager().find(null);
            Optional<Job> launchBarInitJob = Stream.of(jobs).filter(job -> job.getName().equals(Messages.LaunchBarManager_0)).findAny();
            launchBarInitJob.ifPresent(job -> {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    Logger.log(e);
                    Thread.currentThread().interrupt();
                }
            });
            configuration = this.launchBarManager.getActiveLaunchConfiguration();
        }
        return configuration;
    }
}

