/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.bug;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.SystemExecutableFinder;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.FileUtil;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class BugReportGenerator {
    private static final String JAVA_RUNTIME_VERSION_MSG = "Java Runtime Version:";
    private static final String OPERATING_SYSTEM_MSG = "Operating System:";
    private static final String ECLIPSE_CDT_MSG = "Eclipse CDT Version:";
    private static final String IDF_ECLIPSE_PLUGIN_VERSION_MSG = "IDF Eclipse Plugin Version:";
    private static final String ECLIPSE_VERSION_MSG = "Eclipse Version:";
    private static final String PYTHON_IDF_ENV_MSG = "Python set for IDF_PYTHON_ENV:";
    private static final String NOT_FOUND_MSG = "<NOT FOUND>";
    private static final String ECLIPSE_LOG_FILE_NAME = ".log";
    private static final String ECLIPSE_METADATA_DIRECTORY = ".metadata";
    private static final String UNKNOWN = "Unknown";
    private static final String BUG_REPORT_DIRECTORY_PREFIX = "bug_report_";
    private File bugReportDirectory;

    public BugReportGenerator() {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        this.bugReportDirectory = this.getWorkspaceDirectory().resolve(BUG_REPORT_DIRECTORY_PREFIX + timestamp + File.separator).toFile();
    }

    private File getEimLogPath() {
        Object eimPath = "";
        switch (Platform.getOS()) {
            case "win32": {
                eimPath = System.getenv("LOCALAPPDATA");
                if (StringUtil.isEmpty((String)eimPath)) break;
                eimPath = (String)eimPath + "\\eim\\logs";
                break;
            }
            case "macosx": {
                eimPath = System.getProperty("user.home");
                if (StringUtil.isEmpty((String)eimPath)) break;
                eimPath = (String)eimPath + "/Library/Application Support/eim/logs";
                break;
            }
            case "linux": {
                eimPath = System.getProperty("user.home");
                if (StringUtil.isEmpty((String)eimPath)) break;
                eimPath = (String)eimPath + "/.local/share/eim/logs";
                break;
            }
        }
        return new File((String)eimPath);
    }

    private java.nio.file.Path getWorkspaceDirectory() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceRoot = workspace.getRoot().getLocation().toFile();
        return workspaceRoot.toPath();
    }

    private List<File> getIdeMetadataLogsFile() {
        File metadataDir = this.getWorkspaceDirectory().resolve(ECLIPSE_METADATA_DIRECTORY).toFile();
        File[] allFiles = metadataDir.listFiles();
        LinkedList<File> logFiles = new LinkedList<File>();
        if (!metadataDir.exists() || !metadataDir.isDirectory() || allFiles == null) {
            return logFiles;
        }
        File activeLog = new File(metadataDir, ECLIPSE_LOG_FILE_NAME);
        LocalDate refDate = null;
        if (activeLog.exists() && activeLog.isFile()) {
            refDate = Instant.ofEpochMilli(activeLog.lastModified()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                String fileName = file.getName();
                if (fileName.equals("version.ini")) {
                    logFiles.add(file);
                } else if (fileName.endsWith(ECLIPSE_LOG_FILE_NAME)) {
                    LocalDate fileDate;
                    if (fileName.equals(ECLIPSE_LOG_FILE_NAME)) {
                        logFiles.add(file);
                    } else if (refDate != null && ((fileDate = Instant.ofEpochMilli(file.lastModified()).atZone(ZoneId.systemDefault()).toLocalDate()).equals(refDate) || fileDate.equals(refDate.minusDays(1L)))) {
                        logFiles.add(file);
                    }
                }
            }
            ++n2;
        }
        return logFiles;
    }

    private File createBasicSystemInfoFile() throws IOException {
        String osName = System.getProperty("os.name", UNKNOWN);
        String osVersion = System.getProperty("os.version", UNKNOWN);
        String arch = System.getProperty("os.arch", UNKNOWN);
        long freePhys = -1L;
        long totalPhys = -1L;
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            freePhys = osBean.getFreeMemorySize();
            totalPhys = osBean.getTotalMemorySize();
        }
        catch (Throwable osBean) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Basic System Info").append(System.lineSeparator());
        sb.append("==================").append(System.lineSeparator());
        sb.append("Generated: ").append(LocalDateTime.now()).append(System.lineSeparator());
        sb.append("OS       : ").append(osName).append(" ").append(osVersion).append(System.lineSeparator());
        sb.append("Arch     : ").append(arch).append(System.lineSeparator());
        if (totalPhys >= 0L && freePhys >= 0L) {
            long used = totalPhys - freePhys;
            sb.append("Memory   :").append(System.lineSeparator());
            sb.append("  Total         : ").append(BugReportGenerator.humanBytes(totalPhys)).append(" (").append(totalPhys).append(" bytes)").append(System.lineSeparator());
            sb.append("  Available     : ").append(BugReportGenerator.humanBytes(freePhys)).append(" (").append(freePhys).append(" bytes)").append(System.lineSeparator());
            sb.append("  In Use        : ").append(BugReportGenerator.humanBytes(used)).append(" (").append(used).append(" bytes)").append(System.lineSeparator());
        } else {
            sb.append("Memory   : Unavailable (OS-level physical memory query unsupported on this JVM)").append(System.lineSeparator());
        }
        return FileUtil.createFileWithContentsInDirectory("basic_system_info", sb.toString(), this.bugReportDirectory.getAbsolutePath());
    }

    private static String humanBytes(long bytes) {
        double v = bytes;
        ByteUnit unit = ByteUnit.B;
        while (v >= 1024.0 && unit != ByteUnit.PB) {
            v /= 1024.0;
            unit = unit.next();
        }
        return String.format(Locale.ROOT, "%.2f %s", v, unit.label);
    }

    public String generateBugReport() {
        if (!this.bugReportDirectory.exists()) {
            this.bugReportDirectory.mkdirs();
        }
        try {
            File installedToolsFile = this.getInstalledToolsInfoFile();
            File productInfoFile = this.getProductInfoFile();
            File basicSysInfoFile = this.createBasicSystemInfoFile();
            LinkedList<File> filesToZip = new LinkedList<File>();
            filesToZip.add(installedToolsFile);
            filesToZip.add(productInfoFile);
            filesToZip.add(basicSysInfoFile);
            List<File> metadataLogsFile = this.getIdeMetadataLogsFile();
            File ideLogDir = new File(this.bugReportDirectory.getAbsolutePath() + File.separator + "ide_metadata_logs");
            if (!ideLogDir.exists()) {
                ideLogDir.mkdirs();
            }
            for (File logFile : metadataLogsFile) {
                FileUtil.copyFile(logFile, new File(ideLogDir.getAbsolutePath() + File.separator + logFile.getName()));
            }
            File eimLogPath = this.getEimLogPath();
            Logger.log("EIM log path: " + eimLogPath.getAbsolutePath());
            File eimLogDir = new File(this.bugReportDirectory.getAbsolutePath() + File.separator + "eim_logs");
            IStatus status = FileUtil.copyDirectory(eimLogPath, eimLogDir);
            Logger.log("EIM log copy status-code: " + status.getCode());
            Logger.log("EIM log copy status-message: " + status.getMessage());
            FileUtil.zipDirectory(this.bugReportDirectory, this.bugReportDirectory.getAbsolutePath() + ".zip");
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return this.bugReportDirectory.getAbsolutePath() + ".zip";
    }

    private File getInstalledToolsInfoFile() throws IOException {
        File installedToolsFile = new File(this.bugReportDirectory, "installed_tools.txt");
        ArrayList<String> arguments = new ArrayList<String>();
        IPath gitPath = new SystemExecutableFinder().find("git");
        Logger.log("GIT path:" + String.valueOf(gitPath));
        String gitExecutablePath = gitPath.getDevice();
        if (StringUtil.isEmpty(gitExecutablePath)) {
            gitExecutablePath = new IDFEnvironmentVariables().getEnvValue("GIT_PATH");
        }
        arguments.add(IDFUtil.getIDFPythonEnvPath());
        arguments.add(IDFUtil.getIDFToolsScriptFile().getAbsolutePath());
        arguments.add("list");
        Logger.log("Executing command: " + String.join((CharSequence)" ", arguments));
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        Logger.log(((Object)environment).toString());
        environment.put("PYTHONUNBUFFERED", "1");
        if (StringUtil.isEmpty(gitExecutablePath)) {
            Logger.log("Git executable path is empty. Please check GIT_PATH environment variable.");
        } else {
            this.addGitToEnvironment(environment, gitExecutablePath);
        }
        String output = this.runCommand(arguments, environment);
        Files.write(installedToolsFile.toPath(), output.getBytes(), StandardOpenOption.CREATE_NEW);
        return installedToolsFile;
    }

    private void addGitToEnvironment(Map<String, String> environment, String gitExecutablePath) {
        Path gitPath = new Path(gitExecutablePath);
        if (gitPath.toFile().exists()) {
            String gitDir = gitPath.removeLastSegments(1).toOSString();
            String path1 = environment.get("PATH");
            String path2 = environment.get("Path");
            if (!StringUtil.isEmpty(path1) && !path1.contains(gitDir)) {
                path1 = gitDir.concat(";").concat(path1);
                environment.put("PATH", path1);
            } else if (!StringUtil.isEmpty(path2) && !path2.contains(gitDir)) {
                path2 = gitDir.concat(";").concat(path2);
                environment.put("Path", path2);
            }
        }
    }

    private File getProductInfoFile() throws IOException {
        File productInfoFile = new File(this.bugReportDirectory, "product_information.txt");
        String pythonExe = IDFUtil.getIDFPythonEnvPath();
        String idfPath = IDFUtil.getIDFPath();
        if (StringUtil.isEmpty(pythonExe) || StringUtil.isEmpty(idfPath)) {
            Files.write(productInfoFile.toPath(), "IDF_PATH and IDF_PYTHON_ENV_PATH are not found".getBytes(), StandardOpenOption.CREATE_NEW);
            return productInfoFile;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(OPERATING_SYSTEM_MSG + System.getProperty("os.name").toLowerCase());
        sb.append(System.lineSeparator());
        sb.append(JAVA_RUNTIME_VERSION_MSG + Optional.ofNullable(System.getProperty("java.runtime.version")).orElse(NOT_FOUND_MSG));
        sb.append(System.lineSeparator());
        sb.append(ECLIPSE_VERSION_MSG + Optional.ofNullable(Platform.getBundle((String)"org.eclipse.platform")).map(o -> o.getVersion().toString()).orElse(NOT_FOUND_MSG));
        sb.append(System.lineSeparator());
        sb.append(ECLIPSE_CDT_MSG + Optional.ofNullable(Platform.getBundle((String)"org.eclipse.cdt")).map(o -> o.getVersion().toString()).orElse(NOT_FOUND_MSG));
        sb.append(System.lineSeparator());
        sb.append(IDF_ECLIPSE_PLUGIN_VERSION_MSG + Optional.ofNullable(Platform.getBundle((String)"com.espressif.idf.branding")).map(o -> o.getVersion().toString()).orElse(NOT_FOUND_MSG));
        sb.append(System.lineSeparator());
        this.showEspIdfVersion();
        sb.append(PYTHON_IDF_ENV_MSG + Optional.ofNullable(this.getPythonExeVersion(IDFUtil.getIDFPythonEnvPath())).orElse(NOT_FOUND_MSG));
        sb.append(System.lineSeparator());
        Files.write(productInfoFile.toPath(), sb.toString().getBytes(), StandardOpenOption.CREATE_NEW);
        return productInfoFile;
    }

    private void showEspIdfVersion() {
        if (IDFUtil.getIDFPath() != null && IDFUtil.getIDFPythonEnvPath() != null) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(IDFUtil.getIDFPythonEnvPath());
            commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
            commands.add("--version");
            Map<String, String> envMap = new IDFEnvironmentVariables().getSystemEnvMap();
            Logger.log(this.runCommand(commands, envMap));
        } else {
            Logger.log("ESP-IDF version cannot be checked. IDF_PATH or IDF_PYTHON_ENV_PATH  are not set.");
        }
    }

    private String runCommand(List<String> arguments, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, env);
            if (status == null) {
                Logger.log(IDFCorePlugin.getPlugin(), IDFCorePlugin.errorStatus("Status can't be null", null));
            }
            exportCmdOp = status.getMessage();
            Logger.log(exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log(IDFCorePlugin.getPlugin(), e1);
        }
        return exportCmdOp;
    }

    private String getPythonExeVersion(String pythonExePath) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(pythonExePath);
        commands.add("--version");
        return pythonExePath != null ? this.runCommand(commands, IDFUtil.getSystemEnv()) : null;
    }

    private static enum ByteUnit {
        B("B"),
        KB("KB"),
        MB("MB"),
        GB("GB"),
        TB("TB"),
        PB("PB");

        final String label;

        private ByteUnit(String label) {
            this.label = label;
        }

        ByteUnit next() {
            int i = this.ordinal();
            return i < PB.ordinal() ? ByteUnit.values()[i + 1] : PB;
        }
    }
}

