/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.launcher;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimConstants;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.Platform;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.connector.process.ProcessConnector;

public class IDFTerminalProcessConnector
extends ProcessConnector {
    private static final String KEY_INSTALLED = "idfInstalled";
    private static final String KEY_ID = "id";
    private static final String KEY_SCRIPT = "activationScript";

    public void connect(ITerminalControl control) {
        super.connect(control);
        Process process = this.getProcess();
        if (process == null) {
            return;
        }
        this.getActivationScriptPath().ifPresentOrElse(scriptPath -> this.sendCommand(process.getOutputStream(), this.buildActivationCommand((String)scriptPath)), () -> this.sendCommand(process.getOutputStream(), "# Error: ESP-IDF activation script is missing.\r\n"));
    }

    private String buildActivationCommand(String scriptPath) {
        return ". \"" + scriptPath + "\"\r\n";
    }

    private void sendCommand(OutputStream out, String command) {
        try {
            out.write(command.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private Optional<String> getActivationScriptPath() {
        String envPath;
        String string = envPath = Objects.equals(Platform.getOS(), "win32") ? EimConstants.EIM_WIN_PATH : EimConstants.EIM_POSIX_PATH;
        if (envPath == null) {
            return Optional.empty();
        }
        Path path = Path.of(envPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                String selectedId = new IDFEnvironmentVariables().getEnvValue("ESP_IDF_EIM_ID");
                if (selectedId == null) {
                    return Optional.empty();
                }
                if (!root.has(KEY_INSTALLED) || !root.get(KEY_INSTALLED).isJsonArray()) {
                    return Optional.empty();
                }
                JsonArray installed = root.get(KEY_INSTALLED).getAsJsonArray();
                return StreamSupport.stream(installed.spliterator(), false).map(JsonElement::getAsJsonObject).filter(item -> item.has(KEY_ID) && !item.get(KEY_ID).isJsonNull()).filter(item -> selectedId.equals(item.get(KEY_ID).getAsString())).filter(item -> item.has(KEY_SCRIPT) && !item.get(KEY_SCRIPT).isJsonNull()).map(item -> item.get(KEY_SCRIPT).getAsString()).findFirst();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            Logger.log((Exception)e);
            return Optional.empty();
        }
    }
}

