/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools.watcher;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimIdfConfiguratinParser;
import com.espressif.idf.core.tools.SetupToolsInIde;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.core.tools.vo.IdfInstalled;
import com.espressif.idf.core.tools.watcher.EimJsonChangeListener;
import com.espressif.idf.core.tools.watcher.EimJsonStateChecker;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.GlobalModalLock;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.tools.Messages;
import com.espressif.idf.ui.tools.SetupToolsJobListener;
import com.espressif.idf.ui.tools.manager.EimEditorInput;
import com.espressif.idf.ui.tools.manager.pages.ESPIDFMainTablePage;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.osgi.service.prefs.Preferences;

public class EimJsonUiChangeHandler
implements EimJsonChangeListener {
    private Preferences preferences;
    private EimJson eimJson;

    public EimJsonUiChangeHandler(Preferences preferences) {
        this.preferences = preferences;
    }

    public void onJsonFileChanged(Path file, boolean paused) {
        if (paused) {
            Logger.log((String)"Listener is paused");
            return;
        }
        this.displayMessageToUser();
    }

    public void displayMessageToUser() {
        GlobalModalLock.showModal(() -> MessageDialog.openQuestion((Shell)EclipseUtil.getShell(), (String)Messages.EimJsonChangedMsgTitle, (String)Messages.EimJsonChangedMsgDetail), t -> {
            try {
                this.handleUserResponse((Boolean)t);
            }
            catch (EimVersionMismatchException e) {
                MessageDialog.openError((Shell)EclipseUtil.getShell(), (String)e.msgTitle(), (String)e.getMessage());
                Logger.log((Exception)((Object)e));
            }
        });
    }

    public void handleUserResponse(Boolean response) throws EimVersionMismatchException {
        if (response.booleanValue()) {
            try {
                this.loadEimJson();
                if (this.eimJson.getIdfInstalled().size() == 1) {
                    this.setupToolsInIde();
                } else {
                    Display.getDefault().asyncExec(() -> {
                        try {
                            this.launchEspIdfManager();
                        }
                        catch (PartInitException e) {
                            Logger.log((Exception)((Object)e));
                        }
                        ESPIDFMainTablePage.getInstance(this.eimJson).refreshEditorUI();
                    });
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        EimJsonStateChecker checker = new EimJsonStateChecker(this.preferences);
        checker.updateLastSeenTimestamp();
    }

    private void loadEimJson() throws IOException, EimVersionMismatchException {
        EimIdfConfiguratinParser eimIdfConfiguratinParser = new EimIdfConfiguratinParser();
        this.eimJson = eimIdfConfiguratinParser.getEimJson(true);
    }

    private void setupToolsInIde() {
        SetupToolsInIde setupToolsInIde = new SetupToolsInIde((IdfInstalled)this.eimJson.getIdfInstalled().get(0), this.eimJson, this.getConsoleStream(true), this.getConsoleStream(false));
        SetupToolsJobListener toolsActivationJobListener = new SetupToolsJobListener(ESPIDFMainTablePage.getInstance(this.eimJson), setupToolsInIde);
        setupToolsInIde.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
        setupToolsInIde.schedule();
    }

    private void launchEspIdfManager() throws PartInitException {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow activeww = EclipseHandler.getActiveWorkbenchWindow();
            if (activeww == null || activeww.getActivePage() == null) {
                Logger.log((String)"Cannot open ESP-IDF Manager. No active workbench window or active page.");
                return;
            }
            try {
                IDE.openEditor((IWorkbenchPage)activeww.getActivePage(), (IEditorInput)new EimEditorInput(this.eimJson), (String)"com.espressif.idf.ui.manageespidf", (boolean)true);
            }
            catch (PartInitException e) {
                Logger.log((String)"Failed to open ESP-IDF Manager Editor.");
                Logger.log((Exception)((Object)e));
            }
        });
    }

    private MessageConsoleStream getConsoleStream(boolean errorStream) {
        IDFConsole idfConsole = new IDFConsole();
        return idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, errorStream, true);
    }
}

