/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.bug.BugReportGenerator;
import com.espressif.idf.core.bug.GithubIssueOpener;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.update.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class GenerateBugReportCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MessageConsole console = this.uiGetConsole(Messages.IDFToolsHandler_ToolsManagerConsole);
        MessageConsoleStream msgConsole = console.newMessageStream();
        msgConsole.println(Messages.ProductInformationHandler_ProductInformationLogJobName);
        BugReportGenerator generator = new BugReportGenerator();
        String report = generator.generateBugReport();
        msgConsole.println(String.format(Messages.BugReportHandler_CompletedBugReportMsg, report));
        msgConsole.println();
        msgConsole.println("Opening browser to create a new issue...");
        try {
            GithubIssueOpener.openNewIssue();
        }
        catch (Exception e) {
            Logger.log((String)"Failed to open browser to create a new issue");
            Logger.log((Exception)e);
        }
        return null;
    }

    private MessageConsole uiGetConsole(String name) {
        MessageConsole[] result = new MessageConsole[1];
        Display.getDefault().syncExec(() -> {
            messageConsoleArray[0] = this.findConsole(name);
        });
        return result[0];
    }

    private MessageConsole findConsole(String name) {
        IConsole[] existing;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existing = conMan.getConsoles();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole ic = iConsoleArray[n2];
            if (name.equals(ic.getName())) {
                return (MessageConsole)ic;
            }
            ++n2;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

