/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.launcher;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.terminal.connector.serial.connector.SerialSettings;
import com.espressif.idf.terminal.connector.serial.controls.SerialConfigPanel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;

public class SerialLauncherDelegate
extends AbstractLauncherDelegate {
    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new SerialConfigPanel(container);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "com.espressif.idf.terminal.connector.serial.SerialConnector";
        }
        SerialSettings settings = new SerialSettings();
        settings.setPortName((String)properties.get("cdtserial.portName"));
        settings.setFilterText((String)properties.get("idf.monitor.filter"));
        settings.setProject((String)properties.get("idf.monitor.project"));
        Boolean encryptionOption = (Boolean)properties.get("idf.monitor.encryption");
        settings.setEncryptionOption(encryptionOption != null && encryptionOption != false);
        InMemorySettingsStore store = new InMemorySettingsStore();
        settings.save((ISettingsStore)store);
        ITerminalConnector connector = null;
        try {
            connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String name = (String)properties.get("cdtserial.portName");
        properties.put("title", name);
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        try {
            return this.getTerminalService().openConsole(properties);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}

