/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;

public class LaunchTargetHelper {
    private static String lastSavedTargetName;

    private LaunchTargetHelper() {
    }

    public static void saveTargetName(String targetName) {
        lastSavedTargetName = targetName;
    }

    public static Optional<String> getLastTargetName() {
        return Optional.ofNullable(lastSavedTargetName);
    }

    public static ILaunchTarget findLaunchTargetByName(ILaunchTargetManager launchTargetManager, String targetName) {
        ILaunchTarget[] targets = launchTargetManager.getLaunchTargetsOfType("com.espressif.idf.launch.serial.core.serialFlashTarget");
        return LaunchTargetHelper.streamTargetsByName(targetName, targets).findFirst().orElse(null);
    }

    public static Optional<ILaunchTarget> findSuitableTargetForSelectedItem(ILaunchTargetManager launchTargetManager, ILaunchBarManager launchBarManager, String selectedItem) {
        ILaunchTarget[] targets = launchTargetManager.getLaunchTargetsOfType("com.espressif.idf.launch.serial.core.serialFlashTarget");
        String suitableSerialPort = LaunchTargetHelper.getSerialPort(launchBarManager);
        Stream<ILaunchTarget> launchTargetStream = LaunchTargetHelper.streamTargetsByName(selectedItem, targets);
        return launchTargetStream.filter(target -> suitableSerialPort.equals(target.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", ""))).findFirst().or(() -> LaunchTargetHelper.streamTargetsByName(selectedItem, targets).findFirst());
    }

    private static Stream<ILaunchTarget> streamTargetsByName(String selectedItem, ILaunchTarget[] targets) {
        return Stream.of(targets).filter(target -> selectedItem.equals(target.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "")));
    }

    private static String getSerialPort(ILaunchBarManager launchBarManager) {
        String serialPort = "";
        try {
            serialPort = launchBarManager.getActiveLaunchTarget().getAttribute("com.espressif.idf.launch.serial.core.serialPort", "");
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return serialPort;
    }
}

