/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.controls;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.terminal.connector.controls.Messages;
import com.espressif.idf.ui.EclipseUtil;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;
import org.eclipse.ui.WorkbenchEncoding;

public class IDFConsoleWizardConfigurationPanel
extends AbstractExtendedConfigurationPanel {
    private Combo projectCombo;

    public IDFConsoleWizardConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createProjectCombo(panel);
        this.createEncodingUI(panel, false);
        if ("macosx".equals(Platform.getOS()) || "win32".equals(Platform.getOS())) {
            this.setEncoding("UTF-8");
        } else {
            String encoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                this.setEncoding(encoding);
            }
        }
        Label label = new Label(panel, 256);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 300;
        layoutData.heightHint = 80;
        label.setLayoutData((Object)layoutData);
        this.setControl(panel);
    }

    private void createProjectCombo(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label projectLabel = new Label(panel, 0);
        projectLabel.setText(Messages.IDFConsoleWizardConfigurationPanel_IDFConsoleWizardConfigurationPanel_ProjectLabel);
        this.projectCombo = new Combo(panel, 8);
        this.projectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            try {
                if (project2.hasNature(IDFProjectNature.ID)) {
                    this.projectCombo.add(project2.getName());
                }
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
            ++n2;
        }
        Optional<IProject> optProject = Optional.ofNullable(EclipseUtil.getSelectedIDFProjectInExplorer());
        optProject.ifPresentOrElse(project -> this.projectCombo.setText(project.getName()), () -> {
            if (this.projectCombo.getItemCount() > 0) {
                this.projectCombo.select(0);
            }
        });
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        String value = (String)data.get("encoding");
        if (value != null) {
            this.setEncoding(value);
        }
    }

    public void extractData(Map<String, Object> data) {
        IProject p;
        data.put("tm.terminal.connector.id", "com.espressif.idf.terminal.connector.espidfConnector");
        data.put("encoding", this.getEncoding());
        if (this.projectCombo != null && !this.projectCombo.isDisposed() && !this.projectCombo.getText().isEmpty() && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText())) != null && p.exists() && p.getLocation() != null) {
            data.put("process.working_dir", p.getLocation().toOSString());
            data.put("title", p.getName());
        }
    }

    protected void fillSettingsForHost(String host) {
    }

    protected void saveSettingsForHost(boolean add) {
    }

    public boolean isValid() {
        return true;
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doSaveEncodingsWidgetValues(settings, idPrefix);
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doRestoreEncodingsWidgetValues(settings, idPrefix);
    }

    protected String getHostFromSettings() {
        return null;
    }

    public boolean isWithHostList() {
        return false;
    }
}

