/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.update;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.update.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsoleStream;

public class ExportIDFTools {
    public IStatus runToolsExportAndProcessOutput(String pythonExePath, String gitExePath, MessageConsoleStream console, MessageConsoleStream errorConsoleStream) {
        List<String> arguments = this.getExportCommand(pythonExePath);
        String cmd = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
        this.log(cmd, console);
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        if (gitExePath != null) {
            this.addGitToEnvironment(environment, gitExePath);
        }
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null);
            }
            if (status.getSeverity() == 4) {
                this.log(status.getException() != null ? status.getException().getMessage() : status.getMessage(), errorConsoleStream);
                return status;
            }
            String exportCmdOp = status.getMessage();
            this.log(exportCmdOp, console);
            this.processExportCmdOutput(exportCmdOp, gitExePath);
            return status;
        }
        catch (IOException e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            return IDFCorePlugin.errorStatus((String)e1.getMessage(), (Exception)e1);
        }
    }

    public IStatus getToolsExportOutput(String pythonExePath, String gitExePath, MessageConsoleStream console, MessageConsoleStream errorConsoleStream) {
        List<String> arguments = this.getExportCommand(pythonExePath);
        String cmd = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
        this.log(cmd, console);
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        if (gitExePath != null) {
            this.addGitToEnvironment(environment, gitExePath);
        }
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null);
            }
            if (status.getSeverity() == 4) {
                this.log(status.getException() != null ? status.getException().getMessage() : status.getMessage(), errorConsoleStream);
                return status;
            }
            return status;
        }
        catch (IOException e) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e);
            return IDFCorePlugin.errorStatus((String)e.getMessage(), (Exception)e);
        }
    }

    public IStatus getToolsExportOutputFromGivenIdfPath(String pythonExePath, String gitExePath, MessageConsoleStream console, MessageConsoleStream errorConsoleStream, String idfPath) {
        List<String> arguments = this.getExportCommandUsingGivenIdfPath(pythonExePath, idfPath);
        String cmd = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
        this.log(cmd, console);
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        if (gitExePath != null) {
            this.addGitToEnvironment(environment, gitExePath);
        }
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null);
            }
            if (status.getSeverity() == 4) {
                this.log(status.getException() != null ? status.getException().getMessage() : status.getMessage(), errorConsoleStream);
                return status;
            }
            return status;
        }
        catch (IOException e) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e);
            return IDFCorePlugin.errorStatus((String)e.getMessage(), (Exception)e);
        }
    }

    private List<String> getExportCommandUsingGivenIdfPath(String pythonExePath, String idfPath) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(pythonExePath);
        arguments.add(IDFUtil.getIDFToolsScriptFile((String)idfPath).getAbsolutePath());
        arguments.add("export");
        arguments.add("--format=key-value");
        return arguments;
    }

    private List<String> getExportCommand(String pythonExePath) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(pythonExePath);
        arguments.add(IDFUtil.getIDFToolsScriptFile().getAbsolutePath());
        arguments.add("export");
        arguments.add("--format=key-value");
        return arguments;
    }

    private void log(String cmd, MessageConsoleStream console) {
        Logger.log((String)cmd);
        if (console != null) {
            console.println(cmd);
        }
    }

    private String getCommandString(List<String> arguments) {
        StringBuilder builder = new StringBuilder();
        arguments.forEach(entry -> {
            StringBuilder stringBuilder2 = builder.append(entry + " ");
        });
        return builder.toString().trim();
    }

    private void processExportCmdOutput(String exportCmdOp, String gitExecutablePath) {
        String[] exportEntries;
        String[] stringArray = exportEntries = exportCmdOp.split("\n");
        int n = exportEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] keyValue = (entry = entry.replaceAll("\\r", "")).split("=");
            if (keyValue.length == 2) {
                String msg = MessageFormat.format("Key: {0} Value: {1}", keyValue[0], keyValue[1]);
                Logger.log((String)msg);
                IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
                String key = keyValue[0];
                String value = keyValue[1];
                if (key.equals("PATH")) {
                    value = this.replacePathVariable(value);
                    value = this.appendGitToPath(value, gitExecutablePath);
                }
                idfEnvMgr.addEnvVariable(key, value);
            }
            ++n2;
        }
    }

    private String replacePathVariable(String value) {
        HashMap systemEnv = new HashMap(IDFUtil.getSystemEnv());
        String pathEntry = (String)systemEnv.get("PATH");
        if (pathEntry == null && (pathEntry = (String)systemEnv.get("Path")) == null) {
            Logger.log((Exception)new Exception("No PATH found in the system environment variables"));
        }
        if (!StringUtil.isEmpty((String)pathEntry)) {
            value = value.replace("$PATH", pathEntry);
            value = value.replace("%PATH%", pathEntry);
        }
        return value;
    }

    protected void addGitToEnvironment(Map<String, String> envMap, String executablePath) {
        Path gitPath = new Path(executablePath);
        if (gitPath.toFile().exists()) {
            String gitDir = gitPath.removeLastSegments(1).toOSString();
            String path1 = envMap.get("PATH");
            String path2 = envMap.get("Path");
            if (!StringUtil.isEmpty((String)path1) && !path1.contains(gitDir)) {
                path1 = gitDir.concat(";").concat(path1);
                envMap.put("PATH", path1);
            } else if (!StringUtil.isEmpty((String)path2) && !path2.contains(gitDir)) {
                path2 = gitDir.concat(";").concat(path2);
                envMap.put("Path", path2);
            }
        }
    }

    private String appendGitToPath(String path, String gitExecutablePath) {
        Path gitPath = new Path(gitExecutablePath);
        if (!gitPath.toFile().exists()) {
            Logger.log((String)NLS.bind((String)"{0} doesn't exist", (Object)gitExecutablePath));
            return path;
        }
        String gitDir = gitPath.removeLastSegments(1).toOSString();
        if (!StringUtil.isEmpty((String)path) && !path.contains(gitDir)) {
            return path.concat(";").concat(gitDir);
        }
        return path;
    }
}

