/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.handlers.Messages;
import com.espressif.idf.ui.install.GitProgressMonitor;
import com.espressif.idf.ui.update.InstallToolsHandler;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class UpdateEspIdfHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job = new Job(Messages.UpdateEspIdfCommand_JobMsg){

            protected IStatus run(IProgressMonitor monitor) {
                GitProgressMonitor gitProgressMonitor = new GitProgressMonitor(monitor);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Git git = Git.open((File)new File(IDFUtil.getIDFPath()));){
                        git.pull().setProgressMonitor((ProgressMonitor)gitProgressMonitor).call();
                        SubmoduleInitCommand initCommand = git.submoduleInit();
                        SubmoduleUpdateCommand updateCommand = git.submoduleUpdate();
                        this.addRecursivePaths(git.getRepository(), initCommand, updateCommand);
                        initCommand.call();
                        updateCommand.setFetch(true);
                        updateCommand.setProgressMonitor((ProgressMonitor)gitProgressMonitor).call();
                        return Status.OK_STATUS;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | GitAPIException e) {
                    Logger.log((Exception)e);
                    return Status.error((String)e.getLocalizedMessage());
                }
            }

            private void addRecursivePaths(Repository repo, SubmoduleInitCommand initCommand, SubmoduleUpdateCommand updateCommand) throws IOException {
                if (repo == null) {
                    return;
                }
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (SubmoduleWalk generator = SubmoduleWalk.forIndex((Repository)repo);){
                        while (generator.next()) {
                            initCommand.addPath(generator.getPath());
                            updateCommand.addPath(generator.getPath());
                            this.addRecursivePaths(generator.getRepository(), initCommand, updateCommand);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    repo.close();
                }
            }
        };
        MutexRule rule = new MutexRule();
        job.setUser(true);
        this.openProgressView();
        Job installToolsJob = new Job(Messages.UpdateEspIdfCommand_InstallToolsJobMsg){

            protected IStatus run(IProgressMonitor monitor) {
                this.suggestInstallTools();
                return Status.OK_STATUS;
            }

            private void suggestInstallTools() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean isYes = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpdateEspIdfCommand_InstallToolsJobMsg, (String)Messages.UpdateEspIdfCommand_SuggestToOpenInstallToolsWizard);
                        if (isYes) {
                            InstallToolsHandler installToolsHandler = new InstallToolsHandler();
                            try {
                                installToolsHandler.setCommandId("com.espressif.idf.ui.command.install");
                                installToolsHandler.execute(null);
                            }
                            catch (ExecutionException e) {
                                Logger.log((Exception)((Object)e));
                            }
                        }
                    }
                });
            }
        };
        job.setRule((ISchedulingRule)rule);
        installToolsJob.setRule((ISchedulingRule)rule);
        job.schedule();
        installToolsJob.schedule();
        return null;
    }

    private void openProgressView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public class MutexRule
    implements ISchedulingRule {
        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

