/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.launcher;

import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.terminal.connector.serial.launcher.ISerialWebSocketEventLauncher;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GDBStubDebuggerLauncher
implements ISerialWebSocketEventLauncher {
    private static final String GDBSTUB_DEBUG_LAUNCH_CONFIG_FILE = "gdbstub_debug_launch.launch";
    private String messageReceived;
    private IProject project;
    private String port;
    private String elfFile;

    public GDBStubDebuggerLauncher(String messageReceived, IProject project) {
        this.messageReceived = messageReceived;
        this.project = project;
    }

    @Override
    public IFile launchDebugSession() throws Exception {
        this.parseMessageReceived();
        this.createXMLConfig();
        return this.project.getFile(GDBSTUB_DEBUG_LAUNCH_CONFIG_FILE);
    }

    private void parseMessageReceived() throws ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(this.messageReceived);
        JSONObject jsonObject = (JSONObject)obj;
        this.port = jsonObject.get((Object)"port").toString();
        if ("win32".equals(Platform.getOS())) {
            this.port = this.port.replace("\\", "");
            this.port = this.port.replace(".", "");
        }
        this.elfFile = jsonObject.get((Object)"prog").toString();
    }

    private Element createElement(Document dom, Element root, String attribName, String key, String value) {
        Element element = dom.createElement(attribName);
        element.setAttribute("key", key);
        element.setAttribute("value", value);
        root.appendChild(element);
        return element;
    }

    private String getMonitorBaudRate() {
        return new SDKConfigJsonReader(this.project).getValue("ESPTOOLPY_MONITOR_BAUD");
    }

    private void createXMLConfig() throws Exception {
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(IDFUtil.getXtensaToolchainExecutablePath((IProject)this.project));
        commandBuilder.append(" -ex ");
        commandBuilder.append("\"set serial baud ");
        commandBuilder.append(this.getMonitorBaudRate().concat("\""));
        commandBuilder.append(" -ex ");
        commandBuilder.append("\"target remote ");
        commandBuilder.append(this.port.concat("\""));
        commandBuilder.append(" -ex interrupt \"");
        commandBuilder.append(this.elfFile.concat("\""));
        String stringAttribute = "stringAttribute";
        String intAttribute = "intAttribute";
        String booleanAttribute = "booleanAttribute";
        String listAttribute = "listAttribute";
        String listEntry = "listEntry";
        String key = "key";
        String value = "value";
        String mapAttribute = "mapAttribute";
        String booleanFalse = "false";
        String booleanTrue = "true";
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.newDocument();
        Element root = dom.createElement("launchConfiguration");
        dom.appendChild(root);
        Attr attr = dom.createAttribute("type");
        attr.setValue("org.eclipse.cdt.debug.gdbjtag.launchConfigurationType");
        root.setAttributeNode(attr);
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.connection", "gdb:unspecified-ip-address:unspecified-port-number#");
        this.createElement(dom, root, "intAttribute", "org.eclipse.cdt.debug.gdbjtag.core.delay", "0");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.doHalt", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.doReset", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.initCommands", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", "org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.genericDevice");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.loadImage", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", "true");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.pcRegister", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.runCommands", "");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.setResume", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.setStopAt", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", this.elfFile);
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.stopAt", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", "true");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", "true");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.dsf.gdb.DEBUG_NAME", commandBuilder.toString());
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", "");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", "true");
        this.createElement(dom, root, "intAttribute", "org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", "0");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.COREFILE_PATH", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROGRAM_NAME", this.elfFile);
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROJECT_ATTR", this.project.getName());
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", "true");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "org.eclipse.cdt.core.default.config.1039216864");
        Element listMappResPath = dom.createElement("listAttribute");
        listMappResPath.setAttribute("key", "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS");
        Element subListEntryResPath = dom.createElement("listEntry");
        subListEntryResPath.setAttribute("value", "/".concat(this.project.getName()));
        listMappResPath.appendChild(subListEntryResPath);
        root.appendChild(listMappResPath);
        Element listMappResType = dom.createElement("listAttribute");
        listMappResType.setAttribute("key", "org.eclipse.debug.core.MAPPED_RESOURCE_TYPES");
        Element subListEntryResType = dom.createElement("listEntry");
        subListEntryResType.setAttribute("value", "4");
        listMappResType.appendChild(subListEntryResType);
        root.appendChild(listMappResType);
        Element mapElement = dom.createElement("mapAttribute");
        mapElement.setAttribute("key", "org.eclipse.debug.core.preferred_launchers");
        this.createElement(dom, mapElement, "mapEntry", "[debug]", "org.eclipse.cdt.debug.gdbjtag.core.dsfLaunchDelegate");
        root.appendChild(mapElement);
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_DEBUG_ADAPTER", "false");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", "127.0.0.1");
        this.createElement(dom, root, "intAttribute", "org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", "4711");
        this.createElement(dom, root, "stringAttribute", "process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        String launchFile = this.project.getLocation().makeAbsolute().toString().concat("/").concat(GDBSTUB_DEBUG_LAUNCH_CONFIG_FILE);
        tr.transform(new DOMSource(dom), new StreamResult(new File(launchFile)));
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }
}

