/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.controls;

import com.espressif.idf.terminal.connector.serial.connector.SerialConnector;
import com.espressif.idf.terminal.connector.serial.connector.SerialSettings;
import com.espressif.idf.terminal.connector.serial.controls.SerialSettingsPage;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;

public class SerialConfigPanel
extends AbstractExtendedConfigurationPanel {
    private SerialSettings settings;
    private SerialSettingsPage page;

    public SerialConfigPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        SerialConnector connector = new SerialConnector();
        this.settings = connector.getSettings();
        this.page = new SerialSettingsPage(this.settings, (IConfigurationPanel)this);
        this.page.createControl(panel);
        this.createEncodingUI(panel, true);
        this.setControl(panel);
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.page.saveSettings();
        data.put("cdtserial.portName", this.settings.getPortName());
        data.put("idf.monitor.filter", this.settings.getFilterText());
        data.put("idf.monitor.project", this.settings.getProjectName());
        data.put("idf.monitor.encryption", this.settings.getEncryptionOption());
        if (this.getEncoding() != null) {
            data.put("encoding", this.getEncoding());
        }
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.settings.setPortName((String)data.get("cdtserial.portName"));
        this.settings.setFilterText((String)data.get("idf.monitor.filter"));
        Boolean encryptionValue = (Boolean)data.get("idf.monitor.encryption");
        this.settings.setEncryptionOption(encryptionValue != null && encryptionValue != false);
        String encoding = (String)data.get("encoding");
        if (encoding != null) {
            this.setEncoding(encoding);
        }
    }

    protected void saveSettingsForHost(boolean add) {
    }

    protected void fillSettingsForHost(String host) {
    }

    protected String getHostFromSettings() {
        if (this.page != null) {
            this.page.saveSettings();
            return this.settings.getPortName();
        }
        return null;
    }
}

