/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.LaunchUtil;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LaunchBarListener
implements ILaunchBarListener {
    private static boolean targetChangeIgnored = false;

    public static void setIgnoreTargetChange(boolean status) {
        targetChangeIgnored = status;
    }

    public void activeLaunchDescriptorChanged(ILaunchDescriptor descriptor) {
        ILaunchBarManager launchBarManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
        try {
            ILaunchConfiguration activeLaunchConfiguration = launchBarManager.getActiveLaunchConfiguration();
            if (activeLaunchConfiguration != null && activeLaunchConfiguration.getType() != null) {
                String configTypeIdentifier = activeLaunchConfiguration.getType().getIdentifier();
                if ("com.espressif.idf.launch.serial.launchConfigurationType".equals(configTypeIdentifier)) {
                    this.setMode(launchBarManager, "debug");
                    this.setMode(launchBarManager, "run");
                } else if ("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType".equals(configTypeIdentifier)) {
                    this.setMode(launchBarManager, "run");
                    this.setMode(launchBarManager, "debug");
                }
                this.updateProjectBuildFolderBasedOnActiveConfig(activeLaunchConfiguration);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        super.activeLaunchDescriptorChanged(descriptor);
    }

    public void activeLaunchTargetChanged(ILaunchTarget target) {
        Display.getDefault().syncExec(() -> {
            String targetName;
            if (target != null && !StringUtil.isEmpty((String)(targetName = target.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", ""))) && !targetChangeIgnored) {
                this.update(targetName);
            }
        });
    }

    private void update(String newTarget) {
        try {
            ILaunchBarManager launchBarManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
            ILaunchConfiguration activeConfig = launchBarManager.getActiveLaunchConfiguration();
            if (activeConfig == null) {
                return;
            }
            String projectName = activeConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.isEmpty()) {
                ILaunchDescriptor activeLaunchDescriptor = launchBarManager.getActiveLaunchDescriptor();
                projectName = activeLaunchDescriptor.getName();
            }
            if (!StringUtil.isEmpty((String)projectName)) {
                boolean isDelete;
                String currentTarget;
                File buildLocation;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IResource project = workspace.getRoot().findMember(projectName);
                Logger.log((String)("Project Name:: " + projectName));
                Logger.log((String)("Project:: " + String.valueOf(project)));
                if (project != null && (buildLocation = new File(IDFUtil.getBuildDir((IProject)((IProject)project)))).exists() && (currentTarget = new SDKConfigJsonReader((IProject)project).getValue("IDF_TARGET")) != null && !newTarget.equals(currentTarget) && (isDelete = MessageDialog.openQuestion((Shell)EclipseUtil.getShell(), (String)Messages.LaunchBarListener_TargetChanged_Title, (String)MessageFormat.format(Messages.LaunchBarListener_TargetChanged_Msg, project.getName(), currentTarget, newTarget)))) {
                    this.deleteBuildFolder(project, buildLocation);
                }
            }
        }
        catch (CoreException e1) {
            Logger.log((Exception)((Object)e1));
        }
    }

    private void deleteBuildFolder(final IResource project, final File buildLocation) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Deleting build folder...", 1);
                Logger.log((String)("Deleting build folder " + buildLocation.getAbsolutePath()));
                LaunchBarListener.this.deleteDirectory(buildLocation);
                LaunchBarListener.this.cleanSdkConfig(project);
                project.refreshLocal(2, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (String)"Unable to delete the build folder", (Exception)e1);
        }
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        return directoryToBeDeleted.getName().equals("build") || directoryToBeDeleted.delete();
    }

    private void cleanSdkConfig(IResource project) {
        File sdkconfig = new File(project.getLocation().toOSString(), "sdkconfig");
        if (sdkconfig.exists()) {
            File sdkconfigOld = new File(project.getLocation().toOSString(), "sdkconfig.old");
            boolean isRenamed = sdkconfig.renameTo(sdkconfigOld);
            Logger.log((String)NLS.bind((String)"Renaming {0} status...{1}", (Object)sdkconfig.getAbsolutePath(), (Object)isRenamed));
            if (!isRenamed) {
                Logger.log((String)NLS.bind((String)"Deleting {0} status...{1}", (Object)sdkconfigOld.getAbsolutePath(), (Object)sdkconfigOld.delete()));
                sdkconfig.renameTo(sdkconfigOld);
            }
        }
    }

    private void setMode(ILaunchBarManager launchBarManager, String mode) {
        try {
            Optional<ILaunchMode> runMode = Stream.of(launchBarManager.getLaunchModes()).filter(m -> m.getIdentifier().equals(mode)).findFirst();
            if (runMode.isPresent()) {
                launchBarManager.setActiveLaunchMode(runMode.get());
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private void updateProjectBuildFolderBasedOnActiveConfig(ILaunchConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        try {
            if (configuration.getType().getIdentifier().equals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType")) {
                configuration = new LaunchUtil(DebugPlugin.getDefault().getLaunchManager()).getBoundConfiguration(configuration);
            }
            IDFUtil.updateProjectBuildFolder((ILaunchConfigurationWorkingCopy)configuration.getWorkingCopy());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }
}

