/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFCorePreferenceConstants;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.SystemExecutableFinder;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.util.GenericJsonReader;
import com.espressif.idf.core.util.GitWinRegistryReader;
import com.espressif.idf.core.util.Messages;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.core.util.WinNativeFileTagOperations;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class IDFUtil {
    private static Boolean idfSupportsSpaces;

    private IDFUtil() {
    }

    public static File getIDFSysviewTraceScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_sysview_trace_script = idf_path + "/tools/esp_app_trace/sysviewtrace_proc.py";
        return new File(idf_sysview_trace_script);
    }

    public static File getIDFPythonScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_py_script = idf_path + "/tools/idf.py";
        return new File(idf_py_script);
    }

    public static File getIDFPythonScriptFile(String idf_path) {
        String idf_py_script = idf_path + "/tools/idf.py";
        return new File(idf_py_script);
    }

    public static File getIDFMonitorPythonScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_py_script = idf_path + "/tools/idf_monitor.py";
        return new File(idf_py_script);
    }

    public static File getIDFToolsScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_py_script = idf_path + "/tools/idf_tools.py";
        return new File(idf_py_script);
    }

    public static File getIDFToolsScriptFile(String idf_path) {
        String idf_py_script = idf_path + "/tools/idf_tools.py";
        return new File(idf_py_script);
    }

    public static File getIDFMonitorScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_py_monitor_script = idf_path + "/tools/idf_monitor.py";
        return new File(idf_py_monitor_script);
    }

    public static File getIDFSizeScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_py_script = idf_path + "/tools/idf_size.py";
        return new File(idf_py_script);
    }

    public static File getIDFToolsJsonFileForInstallation() {
        String idf_path = IDFUtil.getIDFPath();
        String idf_tools_json_file = idf_path + "/tools/tools.json";
        return new File(idf_tools_json_file);
    }

    public static String getIDFPath() {
        String idfPath = new IDFEnvironmentVariables().getEnvValue("IDF_PATH");
        if (StringUtil.isEmpty(idfPath) && StringUtil.isEmpty(idfPath = System.getProperty("IDF_PATH"))) {
            idfPath = System.getenv("IDF_PATH");
        }
        return idfPath;
    }

    public static String getIDFPythonEnvPath() {
        java.nio.file.Path commandPath;
        Object idfPyEnvPath = new IDFEnvironmentVariables().getEnvValue("IDF_PYTHON_ENV_PATH");
        if (!StringUtil.isEmpty((String)(idfPyEnvPath = ((String)idfPyEnvPath).strip())) && (commandPath = IDFUtil.findCommand("python", (String)(idfPyEnvPath = Platform.getOS().equals("win32") ? (String)idfPyEnvPath + "/Scripts" : (String)idfPyEnvPath + "/bin"))) != null) {
            return commandPath.toFile().getAbsolutePath();
        }
        return IDFUtil.findCommandFromBuildEnvPath("python");
    }

    public static boolean checkIfIdfSupportsSpaces() {
        if (idfSupportsSpaces != null) {
            return idfSupportsSpaces;
        }
        String version = IDFUtil.getEspIdfVersion();
        Pattern p = Pattern.compile("([0-9][.][0-9])");
        Matcher m = p.matcher(version);
        idfSupportsSpaces = m.find() && Double.parseDouble(m.group(0)) >= 5.0;
        return idfSupportsSpaces;
    }

    public static String getPythonExecutable() {
        IPath pythonPath = new SystemExecutableFinder().find("python3");
        if (pythonPath == null) {
            pythonPath = new SystemExecutableFinder().find("python");
        }
        if (pythonPath != null) {
            return pythonPath.toOSString();
        }
        return "python";
    }

    public static java.nio.file.Path findCommand(String command, String pathStr) {
        try {
            String[] path;
            java.nio.file.Path cmdPath = Paths.get(command, new String[0]);
            if (cmdPath.isAbsolute()) {
                return cmdPath;
            }
            String[] stringArray = path = pathStr.split(File.pathSeparator);
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                java.nio.file.Path commandPath = Paths.get(dir, command);
                if (Files.exists(commandPath, new LinkOption[0]) && commandPath.toFile().isFile()) {
                    return commandPath;
                }
                if (Platform.getOS().equals("win32") && !command.endsWith(".exe") && !command.endsWith(".bat") && Files.exists(commandPath = Paths.get(dir, command + ".exe"), new LinkOption[0])) {
                    return commandPath;
                }
                ++n2;
            }
        }
        catch (InvalidPathException e) {
            Logger.log(e);
        }
        return null;
    }

    public static String findCommandFromBuildEnvPath(String command) {
        java.nio.file.Path commandPath;
        String pathStr = new IDFEnvironmentVariables().getEnvValue("PATH");
        if (pathStr != null && (commandPath = IDFUtil.findCommand(command, pathStr)) != null) {
            return commandPath.toFile().getAbsolutePath();
        }
        return null;
    }

    public static String getLineSeparatorValue() {
        IScopeContext scope = InstanceScope.INSTANCE;
        IScopeContext[] scopeContext = new IScopeContext[]{scope};
        IEclipsePreferences node = scopeContext[0].getNode("org.eclipse.core.runtime");
        return node.get("line.separator", System.getProperty("line.separator"));
    }

    public static String getIDFExtraPaths() {
        String IDF_PATH = IDFUtil.getIDFPath();
        if (!StringUtil.isEmpty(IDF_PATH)) {
            IPath IDF_ADD_PATHS_EXTRAS = new Path(IDF_PATH).append("components/esptool_py/esptool");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(":");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(IDF_PATH).append("components/espcoredump");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(":");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(IDF_PATH).append("components/partition_table");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(":");
            IDF_ADD_PATHS_EXTRAS = IDF_ADD_PATHS_EXTRAS.append(IDF_PATH).append("components/app_update");
            return IDF_ADD_PATHS_EXTRAS.toString();
        }
        return "";
    }

    public static String getOpenOCDLocation() {
        String openOCDScriptPath = new IDFEnvironmentVariables().getEnvValue("OPENOCD_SCRIPTS");
        if (!StringUtil.isEmpty(openOCDScriptPath)) {
            return openOCDScriptPath.replace(File.separator + "share" + File.separator + "openocd" + File.separator + "scripts", "") + File.separator + "bin";
        }
        return "";
    }

    public static String getXtensaToolchainExecutablePath(IProject project) {
        String projectEspTarget = null;
        if (project != null) {
            projectEspTarget = new SDKConfigJsonReader(project).getValue("IDF_TARGET");
        }
        return IDFUtil.getXtensaToolchainExecutablePathByTarget(projectEspTarget);
    }

    public static String getToolchainExePathForActiveTarget() {
        ILaunchBarManager launchBarManager = IDFCorePlugin.getService(ILaunchBarManager.class);
        try {
            File file;
            ILaunchTarget launchTarget = launchBarManager.getActiveLaunchTarget();
            if (launchTarget != null && (file = new ESPToolChainManager().findCompiler(launchTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", ""))) != null) {
                return file.getAbsolutePath();
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static String getXtensaToolchainExecutablePathByTarget(String projectEspTarget) {
        File file = new ESPToolChainManager().findDebugger(projectEspTarget);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String getXtensaToolchainExecutableAddr2LinePath(IProject project) {
        IEnvironmentVariable cdtPath;
        Pattern GDB_PATTERN = Pattern.compile("xtensa-esp(.*)-elf-addr2line(\\.exe)?");
        String projectEspTarget = null;
        if (project != null) {
            projectEspTarget = new SDKConfigJsonReader(project).getValue("IDF_TARGET");
        }
        if ((cdtPath = new IDFEnvironmentVariables().getEnv("PATH")) != null) {
            String[] stringArray = cdtPath.getValue().split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dirStr = stringArray[n2];
                File dir = new File(dirStr);
                if (dir.isDirectory()) {
                    File[] fileArray = dir.listFiles();
                    int n3 = fileArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Matcher matcher;
                        File file = fileArray[n4];
                        if (!file.isDirectory() && (matcher = GDB_PATTERN.matcher(file.getName())).matches()) {
                            String path = file.getAbsolutePath();
                            Logger.log("addr2line executable:" + path);
                            String[] tuples = file.getName().split("-");
                            if (projectEspTarget == null) {
                                return path;
                            }
                            if (tuples[1].equals(projectEspTarget)) {
                                return path;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static File getEspToolScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String esp_tool_script = idf_path + "/components/esptool_py/esptool/esptool.py";
        return new File(esp_tool_script);
    }

    public static File getEspCoreDumpScriptFile() {
        String idf_path = IDFUtil.getIDFPath();
        String esp_tool_script = idf_path + "/components/espcoredump/espcoredump.py";
        return new File(esp_tool_script);
    }

    public static String getEspIdfVersion() {
        if (IDFUtil.getIDFPath() != null && IDFUtil.getIDFPythonEnvPath() != null) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(IDFUtil.getIDFPythonEnvPath());
            commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
            commands.add("--version");
            Map<String, String> envMap = new IDFEnvironmentVariables().getSystemEnvMap();
            return IDFUtil.runCommand(commands, envMap);
        }
        return "";
    }

    public static String getOpenocdVersion() {
        String openocdExecutable;
        String openocdLocation = IDFUtil.getOpenOCDLocation();
        String string = openocdExecutable = Platform.getOS().equals("win32") ? "openocd.exe" : "openocd";
        if (openocdLocation != null && !openocdLocation.isBlank()) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(IDFUtil.getOpenOCDLocation() + File.separator + openocdExecutable);
            commands.add("--version");
            Map<String, String> envMap = new IDFEnvironmentVariables().getSystemEnvMap();
            return IDFUtil.runCommand(commands, envMap);
        }
        return "";
    }

    private static String runCommand(List<String> arguments, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, env);
            if (status == null) {
                Logger.log(IDFCorePlugin.getPlugin(), IDFCorePlugin.errorStatus("Status can't be null", null));
                return exportCmdOp;
            }
            exportCmdOp = status.getMessage();
            Logger.log(exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log(IDFCorePlugin.getPlugin(), e1);
        }
        return exportCmdOp;
    }

    public static String getBuildDir(IProject project) throws CoreException {
        String buildDirectory = project.getPersistentProperty(new QualifiedName("com.espressif.idf.core", "idf.buildDirectory.property"));
        if (StringUtil.isEmpty(buildDirectory)) {
            buildDirectory = project.getFolder("build").getLocation().toOSString();
        }
        return buildDirectory;
    }

    public static void setBuildDir(IProject project, String pathToBuildDir) throws CoreException {
        project.setPersistentProperty(new QualifiedName("com.espressif.idf.core", "idf.buildDirectory.property"), pathToBuildDir);
    }

    public static void updateProjectBuildFolder(ILaunchConfigurationWorkingCopy configuration) {
        try {
            IProject project = CoreBuildLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
            if (project == null) {
                return;
            }
            String buildFolder = configuration.getAttribute("com.espressif.idf.launch.serial.core.idfBuildFolderPath", IDFUtil.getBuildDir(project));
            buildFolder = buildFolder.isBlank() ? "build" : buildFolder;
            Path path = new Path(buildFolder);
            if (!path.isAbsolute()) {
                IPath projectLocation = project.getLocation();
                path = projectLocation.append((IPath)path);
            }
            IDFUtil.setBuildDir(project, path.toOSString());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public static IPath getMapFilePath(IProject project) {
        try {
            String buildDir = IDFUtil.getBuildDir(project);
            String filePath = buildDir + File.separator + "project_description.json";
            GenericJsonReader jsonReader = new GenericJsonReader(filePath);
            String value = jsonReader.getValue("app_elf");
            if (!StringUtil.isEmpty(value)) {
                value = value.replace(".elf", ".map");
                return new Path(buildDir).append(value);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static IPath getBinFilePath(IProject project) {
        try {
            String buildDir = IDFUtil.getBuildDir(project);
            String filePath = buildDir + File.separator + "project_description.json";
            GenericJsonReader jsonReader = new GenericJsonReader(filePath);
            String value = jsonReader.getValue("app_bin");
            if (!StringUtil.isEmpty(value)) {
                return new Path(buildDir).append(value);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static IPath getELFFilePath(IProject project) {
        try {
            String buildDir = IDFUtil.getBuildDir(project);
            String filePath = buildDir + File.separator + "project_description.json";
            GenericJsonReader jsonReader = new GenericJsonReader(filePath);
            String value = jsonReader.getValue("app_elf");
            if (!StringUtil.isEmpty(value)) {
                return new Path(buildDir).append(value);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static String getNvsGeneratorScriptPath() {
        return Stream.of(IDFUtil.getIDFPath(), "components", "nvs_flash", "nvs_partition_generator", "nvs_partition_gen.py").collect(Collectors.joining(String.valueOf('/')));
    }

    public static void updateEspressifPrefPageOpenocdPath() {
        IEclipsePreferences newNode = DefaultScope.INSTANCE.getNode("com.espressif.idf.debug.gdbjtag.openocd");
        newNode.put("install.folder", IDFUtil.getOpenOCDLocation());
        try {
            newNode.flush();
        }
        catch (BackingStoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public static String getCurrentTarget() {
        IProject project = IDFUtil.getProjectFromActiveLaunchConfig();
        if (project == null) {
            Logger.log(Messages.IDFUtil_CantFindProjectMsg);
            return null;
        }
        return new SDKConfigJsonReader(project).getValue("IDF_TARGET");
    }

    public static boolean isFlashEncrypted() {
        try {
            ILaunchConfiguration configuration = IDFUtil.getActiveLaunchConfiguration();
            return configuration != null && configuration.getAttribute("com.espressif.idf.launch.FLASH_ENCRYPTION_ENABLED", false);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return false;
        }
    }

    public static IProject getProjectFromActiveLaunchConfig() {
        IResource[] resources;
        block5: {
            ILaunchConfiguration activeConfig;
            block4: {
                try {
                    activeConfig = IDFUtil.getActiveLaunchConfiguration();
                    if (activeConfig != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                    return null;
                }
            }
            resources = activeConfig.getMappedResources();
            if (resources != null && resources.length != 0) break block5;
            Logger.log("No mapped resources in active launch configuration.");
            return null;
        }
        IProject project = resources[0].getProject();
        Logger.log("Active project: " + String.valueOf(project));
        return project;
    }

    private static ILaunchConfiguration getActiveLaunchConfiguration() throws CoreException {
        ILaunchBarManager launchBarManager = IDFCorePlugin.getService(ILaunchBarManager.class);
        if (launchBarManager == null) {
            Logger.log("LaunchBarManager service not found.");
            return null;
        }
        ILaunchConfiguration activeConfig = launchBarManager.getActiveLaunchConfiguration();
        if (activeConfig == null) {
            Logger.log("No active launch configuration.");
            return null;
        }
        return activeConfig;
    }

    public static String getGitExecutablePathFromSystem() {
        IPath gitPath = new SystemExecutableFinder().find("git");
        Logger.log("GIT path:" + String.valueOf(gitPath));
        if (gitPath != null) {
            return gitPath.toOSString();
        }
        if ("win32".equals(Platform.getOS())) {
            GitWinRegistryReader gitWinRegistryReader = new GitWinRegistryReader();
            String gitInstallPath = gitWinRegistryReader.getGitInstallPath();
            if (!StringUtil.isEmpty(gitInstallPath)) {
                return gitInstallPath.concat(String.valueOf('/')).concat("bin").concat(String.valueOf('/')).concat("git.exe");
            }
        } else {
            IStatus status;
            block7: {
                ArrayList<String> arguments = new ArrayList<String>();
                ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
                arguments.add("whereis");
                arguments.add("git");
                HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
                status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
                if (status != null) break block7;
                Logger.log(IDFCorePlugin.getPlugin(), IDFCorePlugin.errorStatus("Status can't be null", null));
                return "";
            }
            try {
                String gitLocation = status.getMessage().split(" ").length > 1 ? status.getMessage().split(" ")[1] : "";
                gitLocation = gitLocation.strip();
                return gitLocation;
            }
            catch (Exception e1) {
                Logger.log(e1);
            }
        }
        return "";
    }

    public static boolean isReparseTag(File file) {
        if (!Platform.getOS().equals("win32")) {
            return false;
        }
        int reparseTag = WinNativeFileTagOperations.getReparseTag(file.getAbsolutePath());
        if (reparseTag != -1) {
            return WinNativeFileTagOperations.isReparseTagMicrosoft(reparseTag);
        }
        return false;
    }

    public static String resolveEnvVariable(String path) {
        Pattern winEnvPattern = Pattern.compile("%(\\w+)%");
        Pattern unixEnvPattern = Pattern.compile("\\$(\\w+)");
        Matcher matcher = Platform.getOS().equals("win32") ? winEnvPattern.matcher(path) : unixEnvPattern.matcher(path);
        StringBuffer resolvedPath = new StringBuffer();
        while (matcher.find()) {
            String envVarName = matcher.group(1);
            String envVarValue = System.getenv(envVarName);
            if (envVarValue != null) {
                matcher.appendReplacement(resolvedPath, envVarValue.replace("\\", "\\\\"));
                continue;
            }
            matcher.appendReplacement(resolvedPath, matcher.group(0));
        }
        matcher.appendTail(resolvedPath);
        return resolvedPath.toString();
    }

    public static Map<String, String> getSystemEnv() {
        String[] brewPaths;
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String idfToolsPath = Platform.getPreferencesService().getString("com.espressif.idf.core", "IDF_TOOLS_PATH", IDFCorePreferenceConstants.IDF_TOOLS_PATH_DEFAULT, null);
        env.put("IDF_TOOLS_PATH", idfToolsPath);
        String keyPath = env.containsKey("PATH") ? "PATH" : "Path";
        String existingPath = env.getOrDefault(keyPath, "");
        StringBuilder newPath = new StringBuilder();
        String[] stringArray = brewPaths = new String[]{"/usr/local/bin", "/opt/homebrew/bin"};
        int n = brewPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String brewPath = stringArray[n2];
            if (Files.exists(Paths.get(brewPath, new String[0]), new LinkOption[0]) && !existingPath.contains(brewPath)) {
                newPath.append(brewPath).append(":");
            }
            ++n2;
        }
        newPath.append(existingPath);
        env.put(keyPath, newPath.toString());
        return env;
    }

    public static String getIDFToolsPathFromPreferences() {
        String idfToolsPath = Platform.getPreferencesService().getString("com.espressif.idf.core", "IDF_TOOLS_PATH", IDFCorePreferenceConstants.IDF_TOOLS_PATH_DEFAULT, null);
        return idfToolsPath;
    }

    public static void closeWelcomePage(IWorkbenchWindow activeww) {
        Display.getDefault().syncExec(() -> {
            ViewPart viewPart;
            IWorkbenchPage page;
            if (activeww != null && (page = activeww.getActivePage()) != null && (viewPart = (ViewPart)page.findView("org.eclipse.ui.internal.introview")) != null) {
                page.hideView((IViewPart)viewPart);
            }
        });
    }

    public static boolean espDetectConfigScriptExists() {
        String openocdBinDir = IDFUtil.getOpenOCDLocation();
        if (StringUtil.isEmpty(openocdBinDir)) {
            return false;
        }
        File binDir = new File(openocdBinDir);
        File openocdRoot = binDir.getParentFile();
        File toolsDir = Paths.get(openocdRoot.getPath(), "share", "openocd", "espressif", "tools").toFile();
        File scriptFile = new File(toolsDir, "esp_detect_config.py");
        return scriptFile.exists();
    }

    public static String runEspDetectConfigScript() {
        IStatus status;
        block8: {
            String openocdBinDir = IDFUtil.getOpenOCDLocation();
            if (StringUtil.isEmpty(openocdBinDir)) {
                Logger.log("OpenOCD location could not be determined.");
                return null;
            }
            File binDir = new File(openocdBinDir);
            File openocdRoot = binDir.getParentFile();
            File scriptsDir = Paths.get(openocdRoot.getPath(), "share", "openocd", "scripts").toFile();
            File toolsDir = Paths.get(openocdRoot.getPath(), "share", "openocd", "espressif", "tools").toFile();
            File configFile = new File(scriptsDir, "esp-config.json");
            if (!configFile.exists()) {
                Logger.log("esp-config.json not found at expected location: " + configFile.getAbsolutePath());
                return null;
            }
            if (!IDFUtil.espDetectConfigScriptExists()) {
                Logger.log("esp_detect_config.py not found at expected location: " + new File(toolsDir, "esp_detect_config.py").getAbsolutePath());
                return null;
            }
            String scriptPath = new File(toolsDir, "esp_detect_config.py").getAbsolutePath();
            String configPath = configFile.getAbsolutePath();
            String openocdExecutable = Platform.getOS().equals("win32") ? "openocd.exe" : "openocd";
            File openocdBin = new File(openocdBinDir, openocdExecutable);
            if (!openocdBin.exists()) {
                Logger.log("OpenOCD binary not found at expected location.");
                return null;
            }
            String idfPythonEnvPath = IDFUtil.getIDFPythonEnvPath();
            if (StringUtil.isEmpty(idfPythonEnvPath)) {
                Logger.log("IDF_PYTHON_ENV_PATH could not be found.");
                return null;
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(idfPythonEnvPath);
            command.add(scriptPath);
            command.add("--esp-config");
            command.add(configPath);
            command.add("--oocd");
            command.add(openocdBin.getAbsolutePath());
            Map<String, String> env = new IDFEnvironmentVariables().getSystemEnvMap();
            try {
                status = new ProcessBuilderFactory().runInBackground(command, null, env);
                if (status != null) break block8;
                Logger.log("esp_detect_config.py did not return a result.");
                return null;
            }
            catch (Exception e) {
                Logger.log(e);
                return null;
            }
        }
        return status.getMessage();
    }
}

