/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFDynamicVariables;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DfuCommandsUtil {
    public static final String DFU_COMMAND = "com.espressif.idf.ui.command.dfu";
    private static final String[] SUPPORTED_TARGETS = new String[]{"esp32s2", "esp32s3"};
    private static final String DFU_FLASH_COMMAND = "dfu-flash";

    private DfuCommandsUtil() {
    }

    public static String[] getSupportedTargets() {
        return SUPPORTED_TARGETS;
    }

    public static boolean isDfu() {
        try {
            ILaunchConfiguration configuration = IDFCorePlugin.getService(ILaunchBarManager.class).getActiveLaunchConfiguration();
            return configuration.getAttribute("DFU", false);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return false;
        }
    }

    public static boolean isDfuSupported(ILaunchTarget launchTarget) {
        boolean isDfuSupported = DfuCommandsUtil.isTargetSupportDfu(launchTarget);
        Display.getDefault().asyncExec(() -> {
            if (!isDfuSupported) {
                MessageDialog.openWarning((Shell)DfuCommandsUtil.getShell(), (String)Messages.DfuWarningDialog_Title, (String)Messages.DfuWarningDialog_WrongTargterMsg);
            }
        });
        return isDfuSupported;
    }

    public static boolean isTargetSupportDfu(ILaunchTarget launchTarget) {
        String targetName = launchTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "");
        return Arrays.stream(SUPPORTED_TARGETS).anyMatch(target -> target.contentEquals(targetName));
    }

    public static String getDfuFlashCommand() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(DfuCommandsUtil.generateVariableExpression(IDFDynamicVariables.IDF_PYTHON_ENV_PATH.name()));
        commands.add(DfuCommandsUtil.generateVariableExpression(IDFDynamicVariables.IDF_PY.name()));
        commands.add(DFU_FLASH_COMMAND);
        return String.join((CharSequence)" ", commands);
    }

    public static List<String> getDfuBuildCommand() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
        commands.add("dfu");
        return commands;
    }

    private static String generateVariableExpression(String variableName) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(variableName, null);
    }

    private static String resolveExpressionFromVariableManager(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
    }

    public static void flashDfuBins(ILaunchConfiguration configuration, IProject project, ILaunch launch) {
        List<Object> flashCommandList = new ArrayList();
        try {
            String flashCommand = configuration.getAttribute("com.espressif.idf.launch.serial.core.dfuFlashArguments", DfuCommandsUtil.getDfuFlashCommand());
            flashCommand = DfuCommandsUtil.resolveExpressionFromVariableManager(flashCommand);
            flashCommandList = Arrays.asList(CommandLineUtil.argumentsToArray((String)flashCommand));
        }
        catch (CoreException e1) {
            Logger.log((Exception)((Object)e1));
        }
        ArrayList commands = new ArrayList();
        commands.addAll(flashCommandList);
        File workingDir = null;
        workingDir = new File(project.getLocationURI());
        Map<String, String> idfEnvMap = new IDFEnvironmentVariables().getSystemEnvMap();
        idfEnvMap.put("PYTHONUNBUFFERED", "1");
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        environment.putAll(idfEnvMap);
        Logger.log(((Object)environment).toString());
        String mergedPath = Stream.of((String)environment.get("PATH"), (String)environment.get("Path")).filter(Objects::nonNull).collect(Collectors.joining(";"));
        if (!mergedPath.isEmpty()) {
            environment.put("PATH", mergedPath);
            environment.remove("Path");
        }
        ArrayList<String> strings = new ArrayList<String>(environment.size());
        for (Map.Entry entry : environment.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        Process p = null;
        String[] envArray = strings.toArray(new String[strings.size()]);
        try {
            p = DebugPlugin.exec((String[])commands.toArray(new String[0]), (File)workingDir, (String[])envArray);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)String.join((CharSequence)" ", commands));
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

