/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.Messages;
import com.espressif.idf.core.build.IDFBuildConfiguration;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public final class IDFHelpers {

    public static class Build {
        private static ICBuildConfigurationManager cdtConfigManager = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);

        public static IBuildConfiguration getBuildConfiguration(IProject project) throws CoreException {
            IBuildConfiguration[] configs;
            IBuildConfiguration buildCfg = project.getActiveBuildConfig();
            if (buildCfg.getName().startsWith("com.espressif.idf.cmake.core.provider")) {
                return buildCfg;
            }
            IBuildConfiguration[] iBuildConfigurationArray = configs = project.getBuildConfigs();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration icb = iBuildConfigurationArray[n2];
                if (icb.getName().startsWith("com.espressif.idf.cmake.core.provider")) {
                    return icb;
                }
                ++n2;
            }
            throw new CoreException(IDFCorePlugin.errorStatus(Messages.IDFHelpers_ProjectNotCreatedCorrectly, new RuntimeException(Messages.IDFHelpers_NoIDFBuildConfig)));
        }

        public static IDFBuildConfiguration getIDFBuildConfiguration(IProject project) throws CoreException {
            IBuildConfiguration buildCfg = Build.getBuildConfiguration(project);
            ICBuildConfiguration appBuildCfg = cdtConfigManager.getBuildConfiguration(buildCfg);
            if (appBuildCfg instanceof IDFBuildConfiguration) {
                return (IDFBuildConfiguration)appBuildCfg;
            }
            throw new CoreException(IDFCorePlugin.errorStatus(Messages.IDFHelpers_ProjectNotCreatedCorrectly, new RuntimeException(Messages.IDFHelpers_NoIDFBuildConfig)));
        }
    }

    public static class Launch {
        public static IDFBuildConfiguration getIDFBuildConfiguration(IProject project) throws CoreException {
            return Build.getIDFBuildConfiguration(project);
        }

        public static IDFBuildConfiguration getIDFBuildConfiguration(IProject project, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
            return Launch.getIDFBuildConfiguration(project);
        }
    }
}

