// Copyright 2015-2016 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at

//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef _EMAC_DESC_H_
#define _EMAC_DESC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "soc/soc.h"

#define REG_EMAC_DESC_BASE 0
#define EMAC_DESC_TDES0_REG (REG_EMAC_DESC_BASE + 0x0000)
#define EMAC_DESC_TX_OWN (BIT(31))
#define EMAC_DESC_TX_OWN_S 31
#define EMAC_DESC_INT_COMPL (BIT(30))
#define EMAC_DESC_INT_COMPL_S 30
#define EMAC_DESC_LAST_SEGMENT (BIT(29))
#define EMAC_DESC_LAST_SEGMENT_S 29
#define EMAC_DESC_FIRST_SEGMENT (BIT(28))
#define EMAC_DESC_FIRST_SEGMENT_S 28
#define EMAC_DESC_DIS_CRC (BIT(27))
#define EMAC_DESC_DIS_CRC_S 27
#define EMAC_DESC_DIS_PAD (BIT(26))
#define EMAC_DESC_DIS_PAD_S 26
#define EMAC_DESC_TX_TS_EN (BIT(25))
#define EMAC_DESC_TX_TS_EN_S 25
#define EMAC_DESC_CRC_REPLACE_CTRL (BIT(24))
#define EMAC_DESC_CRC_REPLACE_CTRL_S 24
#define EMAC_DESC_CHECKSUM_INSERT_CTRL 0x00000003
#define EMAC_DESC_CHECKSUM_INSERT_CTRL_S 22
#define EMAC_DESC_TX_END_OF_RING (BIT(21))
#define EMAC_DESC_TX_END_OF_RING_S 21
#define EMAC_DESC_SECOND_ADDR_CHAIN (BIT(20))
#define EMAC_DESC_SECOND_ADDR_CHAIN_S 20
#define EMAC_DESC_VLAN_INSERT_CTRL 0x00000003
#define EMAC_DESC_VLAN_INSERT_CTRL_S 18
#define EMAC_DESC_TX_TS_STATUS (BIT(17))
#define EMAC_DESC_TX_TS_STATUS_S 17
#define EMAC_DESC_TX_IP_HEAD_ERR (BIT(16))
#define EMAC_DESC_TX_IP_HEAD_ERR_S 16
#define EMAC_DESC_ERR_SUMMARY (BIT(15))
#define EMAC_DESC_ERR_SUMMARY_S 15
#define EMAC_DESC_JABBER_TO (BIT(14))
#define EMAC_DESC_JABBER_TO_S 14
#define EMAC_DESC_FRAME_FLUSH (BIT(13))
#define EMAC_DESC_FRAME_FLUSH_S 13
#define EMAC_DESC_TX_IP_PAYLAD_ERR (BIT(12))
#define EMAC_DESC_TX_IP_PAYLAD_ERR_S 12
#define EMAC_DESC_LOSS_OF_CARRIER (BIT(11))
#define EMAC_DESC_LOSS_OF_CARRIER_S 11
#define EMAC_DESC_NO_CARRIER (BIT(10))
#define EMAC_DESC_NO_CARRIER_S 10
#define EMAC_DESC_LATE_COLLISION_T (BIT(9))
#define EMAC_DESC_LATE_COLLISION_T_S 9
#define EMAC_DESC_EXCESSIVE_COLLISION (BIT(8))
#define EMAC_DESC_EXCESSIVE_COLLISION_S 8
#define EMAC_DESC_VLAN_FRAME (BIT(7))
#define EMAC_DESC_VLAN_FRAME_S 7
#define EMAC_DESC_COLLISION_COUNT 0x0000000F
#define EMAC_DESC_COLLISION_COUNT_S 3
#define EMAC_DESC_EXCESSIVE_DEFERRAL (BIT(2))
#define EMAC_DESC_EXCESSIVE_DEFERRAL_S 2
#define EMAC_DESC_UNDERFLOW_ERR (BIT(1))
#define EMAC_DESC_UNDERFLOW_ERR_S 1
#define EMAC_DESC_DEFFER_BIT (BIT(0))
#define EMAC_DESC_DEFFER_BIT_S 0

#define EMAC_DESC_TDES1_REG (REG_EMAC_DESC_BASE + 0x0004)
#define EMAC_DESC_SA_INSERT_CRTL 0x00000007
#define EMAC_DESC_SA_INSERT_CRTL_S 29
#define EMAC_DESC_TX_BUFFER1_SIZE 0x00001FFF
#define EMAC_DESC_TX_BUFFER1_SIZE_S 0

#define EMAC_DESC_TDES2_REG (REG_EMAC_DESC_BASE + 0x0008)
#define EMAC_DESC_TX_BUFFER1_ADDR_PTR 0xFFFFFFFF
#define EMAC_DESC_TX_BUFFER1_ADDR_PTR_S 0

#define EMAC_DESC_TDES3_REG (REG_EMAC_DESC_BASE + 0x000C)
#define EMAC_DESC_TX_NEXT_DESC_ADDR 0xFFFFFFFF
#define EMAC_DESC_TX_NEXT_DESC_ADDR_S 0

#define EMAC_DESC_TDES4_REG (REG_EMAC_DESC_BASE + 0x0010)

#define EMAC_DESC_TDES5_REG (REG_EMAC_DESC_BASE + 0x0014)

#define EMAC_DESC_TDES6_REG (REG_EMAC_DESC_BASE + 0x0018)
#define EMAC_DESC_TX_FRAME_TS_LOW 0xFFFFFFFF
#define EMAC_DESC_TX_FRAME_TS_LOW_S 0

#define EMAC_DESC_TDES7_REG (REG_EMAC_DESC_BASE + 0x001C)
#define EMAC_DESC_TX_FRAME_TS_HIGH 0xFFFFFFFF
#define EMAC_DESC_TX_FRAME_TS_HIGH_S 0

#define EMAC_DESC_RDES0_REG (REG_EMAC_DESC_BASE + 0x0000)
#define EMAC_DESC_RX_OWN (BIT(31))
#define EMAC_DESC_RX_OWN_S 31
#define EMAC_DESC_DEST_ADDR_FILTER_FAIL (BIT(30))
#define EMAC_DESC_DEST_ADDR_FILTER_FAIL_S 30
#define EMAC_DESC_FRAME_LENGTH 0x00003FFF
#define EMAC_DESC_FRAME_LENGTH_S 16
#define EMAC_DESC_ERROR_SUMMARY (BIT(15))
#define EMAC_DESC_ERROR_SUMMARY_S 15
#define EMAC_DESC_DESC_ERR (BIT(14))
#define EMAC_DESC_DESC_ERR_S 14
#define EMAC_DESC_SOURCE_ADDR_FILTER_FAIL (BIT(13))
#define EMAC_DESC_SOURCE_ADDR_FILTER_FAIL_S 13
#define EMAC_DESC_LENGTH_ERR (BIT(12))
#define EMAC_DESC_LENGTH_ERR_S 12
#define EMAC_DESC_OVERFLOW_ERR (BIT(11))
#define EMAC_DESC_OVERFLOW_ERR_S 11
#define EMAC_DESC_VLAN_TAG (BIT(10))
#define EMAC_DESC_VLAN_TAG_S 10
#define EMAC_DESC_FRIST_DESC (BIT(9))
#define EMAC_DESC_FRIST_DESC_S 9
#define EMAC_DESC_LAST_DESC (BIT(8))
#define EMAC_DESC_LAST_DESC_S 8
#define EMAC_DESC_TS_AV_IP_CHK_ERR (BIT(7))
#define EMAC_DESC_TS_AV_IP_CHK_ERR_S 7
#define EMAC_DESC_LATE_COLLISION (BIT(6))
#define EMAC_DESC_LATE_COLLISION_S 6
#define EMAC_DESC_FRAME_TYPE (BIT(5))
#define EMAC_DESC_FRAME_TYPE_S 5
#define EMAC_DESC_RX_WDT_TO (BIT(4))
#define EMAC_DESC_RX_WDT_TO_S 4
#define EMAC_DESC_RX_ERR (BIT(3))
#define EMAC_DESC_RX_ERR_S 3
#define EMAC_DESC_DRIBBLE_BIT_ERR (BIT(2))
#define EMAC_DESC_DRIBBLE_BIT_ERR_S 2
#define EMAC_DESC_CRC_ERR (BIT(1))
#define EMAC_DESC_CRC_ERR_S 1
#define EMAC_DESC_EXT_STATUS_AVAIL (BIT(0))
#define EMAC_DESC_EXT_STATUS_AVAIL_S 0

#define EMAC_DESC_RDES1_REG (REG_EMAC_DESC_BASE + 0x0004)
#define EMAC_DESC_DIS_INT_ON_COMPLET (BIT(31))
#define EMAC_DESC_DIS_INT_ON_COMPLET_S 31
#define EMAC_DESC_RX_END_OF_RING (BIT(15))
#define EMAC_DESC_RX_END_OF_RING_S 15
#define EMAC_DESC_RX_SECOND_ADDR_CHAIN (BIT(14))
#define EMAC_DESC_RX_SECOND_ADDR_CHAIN_S 14
#define EMAC_DESC_RX_BUFFER1_SIZE 0x00001FFF
#define EMAC_DESC_RX_BUFFER1_SIZE_S 0

#define EMAC_DESC_RDES2_REG (REG_EMAC_DESC_BASE + 0x0008)
#define EMAC_DESC_RX_BUFFER1_ADDR_PTR 0xFFFFFFFF
#define EMAC_DESC_RX_BUFFER1_ADDR_PTR_S 0

#define EMAC_DESC_RDES3_REG (REG_EMAC_DESC_BASE + 0x000c)
#define EMAC_DESC_RX_NEXT_DESC_ADDR 0xFFFFFFFF
#define EMAC_DESC_RX_NEXT_DESC_ADDR_S 0

#define EMAC_DESC_RDES4_REG (REG_EMAC_DESC_BASE + 0x0010)
#define EMAC_DESC_VLAN_TAG_PRIOR_VALUE 0x00000007
#define EMAC_DESC_VLAN_TAG_PRIOR_VALUE_S 18
#define EMAC_DESC_TS_DROP (BIT(14))
#define EMAC_DESC_TS_DROP_S 14
#define EMAC_DESC_PTP_VERSION (BIT(13))
#define EMAC_DESC_PTP_VERSION_S 13
#define EMAC_DESC_PTP_FRAME_TYPE (BIT(12))
#define EMAC_DESC_PTP_FRAME_TYPE_S 12
#define EMAC_DESC_MESSAGE_TYPE 0x0000000F
#define EMAC_DESC_MESSAGE_TYPE_S 8
#define EMAC_DESC_IPV6_PACK_RECEIVE (BIT(7))
#define EMAC_DESC_IPV6_PACK_RECEIVE_S 7
#define EMAC_DESC_IPV4_PACK_RECEIVE (BIT(6))
#define EMAC_DESC_IPV4_PACK_RECEIVE_S 6
#define EMAC_DESC_IP_CHECKSUM_BYPASS (BIT(5))
#define EMAC_DESC_IP_CHECKSUM_BYPASS_S 5
#define EMAC_DESC_RX_IP_PAYLAD_ERR (BIT(4))
#define EMAC_DESC_RX_IP_PAYLAD_ERR_S 4
#define EMAC_DESC_RX_IP_HEAD_ERR (BIT(3))
#define EMAC_DESC_RX_IP_HEAD_ERR_S 3
#define EMAC_DESC_IP_PAYLOAD_TYPE 0x00000007
#define EMAC_DESC_IP_PAYLOAD_TYPE_S 0

#define EMAC_DESC_RDES5_REG (REG_EMAC_DESC_BASE + 0x0014)

#define EMAC_DESC_RDES6_REG (REG_EMAC_DESC_BASE + 0x0018)
#define EMAC_DESC_RX_FRAME_TS_LOW 0xFFFFFFFF
#define EMAC_DESC_RX_FRAME_TS_LOW_S 0

#define EMAC_DESC_RDES7_REG (REG_EMAC_DESC_BASE + 0x001C)
#define EMAC_DESC_RX_FRAME_TS_HIGH 0xFFFFFFFF
#define EMAC_DESC_RX_FRAME_TS_HIGH_S 0

#ifdef __cplusplus
}
#endif

#endif

