ESP-IDF A2DP-SOURCE demo
========================

Demo of A2DP audio source role

This is the demo of using Advanced Audio Distribution Profile APIs to transmit audio stream. Applications can take advantage of this example to implement portable audio players or microphones to transmit audio stream to A2DP sink devices.

## How to use this example

### Hardware Required

This example is able to run on any commonly available ESP32 development board, and is supposed to connect to A2DP sink example in ESP-IDF.

### Configure the project

```
make menuconfig
```

* Set serial port under Serial Flasher Options.

* Enable Classic Bluetooth and A2DP under Component config --> Bluetooth --> Bluedroid Enable

### Build and Flash

Build the project and flash it to the board, then run monitor tool to view serial output.

```
make -j4 flash monitor
```

(To exit the serial monitor, type ``Ctrl-]``.)

## Example Output

For the first step, this example performs device discovery to search for a target device (A2DP sink) whose device name is "ESP_SPEAKER" and whose "Rendering" bit of its Service Class field is set in its Class of Device. If a candidate target is found, the local device will initiate connection with it.

After connection with A2DP sink is established, the example performs the following running loop 1-2-3-4-1:
1. audio transmission starts and lasts for a while
2. audio transmission stops
3. disconnect with target device
4. reconnect to target device

The example implements an event loop triggered by a periodic "heart beat" timer and events from Bluetooth protocol stack callback functions.

After the local device discovers the target device and initiates connection, there will be logging message like this:

```
I (4090) BT_AV: Found a target device, address 24:0a:c4:02:0e:ee, name ESP_SPEAKER
I (4090) BT_AV: Cancel device discovery ...
I (4100) BT_AV: Device discovery stopped.
I (4100) BT_AV: a2dp connecting to peer: ESP_SPEAKER
```

If connection is set up successfully, there will be such message:

```
I (5100) BT_AV: a2dp connected
```

Start of audio transmission has the following notification message:

```
I (10880) BT_AV: a2dp media ready checking ...
...
I (10880) BT_AV: a2dp media ready, starting ...
...
I (11400) BT_AV: a2dp media start successfully.
```

Stop of audio transmission, and disconnection with remote device generate the following notification message:

```
I (110880) BT_AV: a2dp media stopping...
...
I (110920) BT_AV: a2dp media stopped successfully, disconnecting...
...
I (111040) BT_AV: a2dp disconnected
```

## Troubleshooting
* For current stage, the supported audio codec in ESP32 A2DP is SBC. SBC audio stream is encoded from PCM data normally formatted as 44.1kHz sampling rate, two-channel 16-bit sample data. Other SBC configurations can be supported but there is a need for additional modifications to the protocol stack.
* The raw PCM media stream in the example is generated by a sequence of random number, so the sound played on the sink side will be piercing noise.
* As a usage limitation, ESP32 A2DP source can support at most one connection with remote A2DP sink devices. Also, A2DP source cannot be used together with A2DP sink at the same time, but can be used with other profiles such as SPP and HFP.

